/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.StringUtil;

public abstract class AbstractMetadataRecord
implements Serializable {
    private static final Collection<AbstractMetadataRecord> EMPTY_INCOMING = Collections.emptyList();
    private static final long serialVersionUID = 564092984812414058L;
    public static final char NAME_DELIM_CHAR = '.';
    private static AtomicLong UUID_SEQUENCE = new AtomicLong();
    private String uuid;
    private String name;
    private String nameInSource;
    private volatile Map<String, String> properties;
    private String annotation;
    private transient Collection<AbstractMetadataRecord> incomingObjects;
    public static final String RELATIONAL_URI = "{http://www.teiid.org/ext/relational/2012}";

    public String getUUID() {
        if (this.uuid == null) {
            this.uuid = String.valueOf(UUID_SEQUENCE.getAndIncrement());
        }
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getNameInSource() {
        return this.nameInSource;
    }

    public void setNameInSource(String nameInSource) {
        this.nameInSource = DataTypeManager.getCanonicalString((String)nameInSource);
    }

    public String getSourceName() {
        if (this.nameInSource != null && this.nameInSource.length() > 0) {
            return this.nameInSource;
        }
        return this.getName();
    }

    public String getFullName() {
        AbstractMetadataRecord parent = this.getParent();
        if (parent != null) {
            String result = parent.getFullName() + '.' + this.getName();
            return result;
        }
        return this.name;
    }

    public void getSQLString(StringBuilder sb) {
        AbstractMetadataRecord parent = this.getParent();
        if (parent != null) {
            parent.getSQLString(sb);
            sb.append('.');
        }
        sb.append('\"').append(StringUtil.replace((String)this.name, (String)"\"", (String)"\"\"")).append('\"');
    }

    public String getSQLString() {
        StringBuilder sb = new StringBuilder();
        this.getSQLString(sb);
        return sb.toString();
    }

    public AbstractMetadataRecord getParent() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = DataTypeManager.getCanonicalString((String)name);
    }

    public String getCanonicalName() {
        return this.name.toUpperCase();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getClass().getSimpleName());
        sb.append(" name=");
        sb.append(this.getName());
        sb.append(", nameInSource=");
        sb.append(this.getNameInSource());
        sb.append(", uuid=");
        sb.append(this.getUUID());
        return sb.toString();
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public String getProperty(String key, boolean checkUnqualified) {
        String value = this.getProperties().get(key);
        if (value != null || !checkUnqualified) {
            return value;
        }
        int index = key.indexOf(125);
        if (index > 0 && index < key.length() && key.charAt(0) == '{') {
            key = key.substring(index + 1, key.length());
        }
        return this.getProperties().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setProperty(String key, String value) {
        if (this.properties == null) {
            AbstractMetadataRecord abstractMetadataRecord = this;
            synchronized (abstractMetadataRecord) {
                if (this.properties == null && value == null) {
                    return null;
                }
                this.properties = new ConcurrentSkipListMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            }
        }
        if (value == null) {
            return this.properties.remove(key);
        }
        return this.properties.put(DataTypeManager.getCanonicalString((String)key), DataTypeManager.getCanonicalString((String)value));
    }

    public synchronized void setProperties(Map<String, String> properties) {
        if (this.properties == null) {
            this.properties = new ConcurrentSkipListMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        } else {
            this.properties.clear();
        }
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = DataTypeManager.getCanonicalString((String)annotation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractMetadataRecord other = (AbstractMetadataRecord)obj;
        return EquivalenceUtil.areEqual((Object)this.getUUID(), (Object)other.getUUID());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.properties != null && !(this.properties instanceof ConcurrentSkipListMap)) {
            this.properties = new ConcurrentSkipListMap<String, String>(this.properties);
        }
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }

    public Collection<AbstractMetadataRecord> getIncomingObjects() {
        if (this.incomingObjects == null) {
            return EMPTY_INCOMING;
        }
        return this.incomingObjects;
    }

    public void setIncomingObjects(Collection<AbstractMetadataRecord> incomingObjects) {
        this.incomingObjects = incomingObjects;
    }

    public boolean isUUIDSet() {
        return this.uuid != null && this.uuid.length() > 0 && !Character.isDigit(this.uuid.charAt(0));
    }

    public String getIdentifier() {
        return this.getName();
    }

    public static interface DataModifiable {
        public static final String DATA_TTL = "{http://www.teiid.org/ext/relational/2012}data-ttl";

        public long getLastDataModification();
    }

    public static interface Modifiable {
        public long getLastModified();
    }
}

