/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.teiid.adminapi.AdminPlugin;
import org.teiid.adminapi.DataPolicy;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;

public class DataPolicyMetadata
implements DataPolicy,
Serializable {
    private static final long serialVersionUID = -4119646357275977190L;
    protected String name;
    protected String description;
    protected boolean anyAuthenticated;
    protected Boolean allowCreateTemporaryTables;
    protected Map<ResourceKey, PermissionMetaData> permissions = new TreeMap<ResourceKey, PermissionMetaData>();
    protected Map<String, PermissionMetaData> languagePermissions = new HashMap<String, PermissionMetaData>(2);
    protected List<String> mappedRoleNames = new CopyOnWriteArrayList<String>();
    private Set<String> hasRowPermissions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private boolean grantAll;
    private Set<String> schemas;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Override
    public List<DataPolicy.DataPermission> getPermissions() {
        ArrayList<DataPolicy.DataPermission> result = new ArrayList<DataPolicy.DataPermission>(this.permissions.values());
        result.addAll(this.languagePermissions.values());
        return result;
    }

    public PermissionMetaData getPermissionMetadata(String resourceName, DataPolicy.ResourceType type) {
        PermissionMetaData result = this.permissions.get(ResourceKey.of(resourceName, type));
        if (result == null && type != DataPolicy.ResourceType.DATABASE) {
            result = this.permissions.get(ResourceKey.of(resourceName, DataPolicy.ResourceType.DATABASE));
        }
        return result;
    }

    public boolean hasRowSecurity(String resourceName) {
        return this.hasRowPermissions.contains(resourceName);
    }

    public void setPermissions(List<DataPolicy.DataPermission> permissions) {
        this.permissions.clear();
        for (DataPolicy.DataPermission permission : permissions) {
            this.addPermissionMetadata((PermissionMetaData)permission);
        }
    }

    public void addPermission(PermissionMetaData ... perms) {
        for (PermissionMetaData permission : perms) {
            this.addPermissionMetadata(permission);
        }
    }

    private void addPermissionMetadata(PermissionMetaData permission) {
        PermissionMetaData previous = null;
        previous = permission.getAllowLanguage() != null ? this.languagePermissions.put(permission.getResourceName(), permission) : this.permissions.put(ResourceKey.of(permission.getResourceName(), permission.getResourceType()), permission);
        if (permission.getCondition() != null) {
            this.hasRowPermissions.add(permission.getResourceName());
        }
        if (permission.getMask() != null) {
            String resourceName = permission.getResourceName();
            int lastSegment = permission.getResourceName().lastIndexOf(46);
            if (lastSegment > 0) {
                resourceName = resourceName.substring(0, lastSegment);
            }
            this.hasRowPermissions.add(resourceName);
        }
        if (previous != null) {
            permission.bits = (byte)(permission.bits | previous.bits);
            permission.bitsSet = (byte)(permission.bitsSet | previous.bitsSet);
            if (previous.getCondition() != null) {
                if (permission.getCondition() == null) {
                    permission.setCondition(previous.getCondition());
                    permission.setConstraint(previous.getConstraint());
                } else {
                    throw new TeiidRuntimeException((BundleUtil.Event)AdminPlugin.Event.TEIID70053, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70053, new Object[]{this.getName(), permission.getResourceName()}));
                }
            }
            if (previous.getMask() != null) {
                if (permission.getMask() != null) {
                    throw new TeiidRuntimeException((BundleUtil.Event)AdminPlugin.Event.TEIID70053, AdminPlugin.Util.gs((BundleUtil.Event)AdminPlugin.Event.TEIID70053, new Object[]{this.getName(), permission.getResourceName()}));
                }
                permission.setMask(previous.getMask());
                permission.setOrder(previous.getOrder());
            }
        }
    }

    @Override
    public List<String> getMappedRoleNames() {
        return this.mappedRoleNames;
    }

    public void setMappedRoleNames(List<String> names) {
        this.mappedRoleNames.clear();
        this.mappedRoleNames.addAll(names);
    }

    public void addMappedRoleName(String mappedName) {
        this.mappedRoleNames.add(mappedName);
    }

    public void removeMappedRoleName(String mappedName) {
        this.mappedRoleNames.remove(mappedName);
    }

    public Boolean allows(String resourceName, DataPolicy.ResourceType resourceType, DataPolicy.PermissionType type) {
        PermissionMetaData p = null;
        if (type == DataPolicy.PermissionType.LANGUAGE) {
            p = this.languagePermissions.get(resourceName);
        } else {
            p = this.permissions.get(ResourceKey.of(resourceName, resourceType));
            if (p == null && resourceType != DataPolicy.ResourceType.DATABASE) {
                p = this.permissions.get(ResourceKey.of(resourceName, DataPolicy.ResourceType.DATABASE));
            }
        }
        if (p != null) {
            return p.allows(type);
        }
        return null;
    }

    @Override
    public Boolean isAllowCreateTemporaryTables() {
        return this.allowCreateTemporaryTables;
    }

    public void setAllowCreateTemporaryTables(Boolean allowCreateTemporaryTables) {
        this.allowCreateTemporaryTables = allowCreateTemporaryTables;
    }

    @Override
    public boolean isAnyAuthenticated() {
        return this.anyAuthenticated;
    }

    public void setAnyAuthenticated(boolean anyAuthenticated) {
        this.anyAuthenticated = anyAuthenticated;
    }

    @Override
    public boolean isGrantAll() {
        return this.grantAll;
    }

    public void setGrantAll(boolean grantAll) {
        this.grantAll = grantAll;
    }

    public DataPolicyMetadata clone() {
        DataPolicyMetadata clone = new DataPolicyMetadata();
        clone.allowCreateTemporaryTables = this.allowCreateTemporaryTables;
        clone.anyAuthenticated = this.anyAuthenticated;
        clone.description = this.description;
        clone.hasRowPermissions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        clone.hasRowPermissions.addAll(this.hasRowPermissions);
        clone.languagePermissions = new HashMap<String, PermissionMetaData>(this.languagePermissions);
        clone.mappedRoleNames = this.mappedRoleNames;
        clone.name = this.name;
        clone.grantAll = this.grantAll;
        clone.permissions = new TreeMap<ResourceKey, PermissionMetaData>(this.permissions);
        return clone;
    }

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Set<String> schemas) {
        this.schemas = schemas;
    }

    public static class PermissionMetaData
    implements DataPolicy.DataPermission,
    Serializable {
        private static final long serialVersionUID = 7034744531663164277L;
        private String resourceName;
        protected byte bits;
        protected byte bitsSet;
        private DataPolicy.ResourceType resourceType;
        private RowSecurityState rowSecurityState;

        @Override
        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String value) {
            this.resourceName = value;
        }

        public void setResourceType(DataPolicy.ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public DataPolicy.ResourceType getResourceType() {
            return this.resourceType;
        }

        @Override
        public Boolean getAllowCreate() {
            return this.bitSet(1);
        }

        private Boolean bitSet(int bitMask) {
            if ((this.bitsSet & bitMask) == bitMask) {
                if ((this.bits & bitMask) == bitMask) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return null;
        }

        private void setBit(int bitMask, Boolean bool) {
            if (bool == null) {
                this.bitsSet = (byte)(this.bitsSet & ~bitMask);
                this.bits = (byte)(this.bits & ~bitMask);
                return;
            }
            this.bitsSet = (byte)(this.bitsSet | bitMask);
            this.bits = bool != false ? (byte)(this.bits | bitMask) : (byte)(this.bits & ~bitMask);
        }

        public void setAllowCreate(Boolean value) {
            this.setBit(1, value);
        }

        @Override
        public Boolean getAllowRead() {
            return this.bitSet(2);
        }

        public void setAllowRead(Boolean value) {
            this.setBit(2, value);
        }

        @Override
        public Boolean getAllowUpdate() {
            return this.bitSet(4);
        }

        public void setAllowUpdate(Boolean value) {
            this.setBit(4, value);
        }

        @Override
        public Boolean getAllowDelete() {
            return this.bitSet(8);
        }

        public void setAllowDelete(Boolean value) {
            this.setBit(8, value);
        }

        public String getType() {
            StringBuilder sb = new StringBuilder();
            if (Boolean.TRUE.equals(this.getAllowCreate())) {
                sb.append("C");
            }
            if (Boolean.TRUE.equals(this.getAllowRead())) {
                sb.append("R");
            }
            if (Boolean.TRUE.equals(this.getAllowUpdate())) {
                sb.append("U");
            }
            if (Boolean.TRUE.equals(this.getAllowDelete())) {
                sb.append("D");
            }
            if (Boolean.TRUE.equals(this.getAllowExecute())) {
                sb.append("E");
            }
            if (Boolean.TRUE.equals(this.getAllowAlter())) {
                sb.append("A");
            }
            if (Boolean.TRUE.equals(this.getAllowLanguage())) {
                sb.append("L");
            }
            if (this.rowSecurityState != null) {
                if (this.rowSecurityState.condition != null) {
                    sb.append(" condition ").append(this.rowSecurityState.condition);
                }
                if (this.rowSecurityState.mask != null) {
                    sb.append(" mask ").append(this.rowSecurityState.mask);
                }
            }
            return sb.toString();
        }

        public Boolean allows(DataPolicy.PermissionType type) {
            switch (type) {
                case ALTER: {
                    return this.getAllowAlter();
                }
                case CREATE: {
                    return this.getAllowCreate();
                }
                case EXECUTE: {
                    if (this.getAllowExecute() != null) {
                        return this.getAllowExecute();
                    }
                }
                case READ: {
                    return this.getAllowRead();
                }
                case UPDATE: {
                    return this.getAllowUpdate();
                }
                case DELETE: {
                    return this.getAllowDelete();
                }
                case LANGUAGE: {
                    return this.getAllowLanguage();
                }
            }
            throw new AssertionError();
        }

        @Override
        public Boolean getAllowAlter() {
            return this.bitSet(16);
        }

        @Override
        public Boolean getAllowExecute() {
            return this.bitSet(32);
        }

        public void setAllowAlter(Boolean allowAlter) {
            this.setBit(16, allowAlter);
        }

        public void setAllowExecute(Boolean allowExecute) {
            this.setBit(32, allowExecute);
        }

        @Override
        public Boolean getAllowLanguage() {
            return this.bitSet(64);
        }

        public void setAllowLanguage(Boolean value) {
            this.setBit(64, value);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getResourceName());
            sb.append("[");
            sb.append(this.getType());
            sb.append("]");
            return sb.toString();
        }

        @Override
        public String getCondition() {
            if (this.rowSecurityState == null) {
                return null;
            }
            return this.rowSecurityState.condition;
        }

        public void setCondition(String filter) {
            if (this.rowSecurityState == null) {
                if (filter == null) {
                    return;
                }
                this.rowSecurityState = new RowSecurityState();
            }
            this.rowSecurityState.condition = filter;
        }

        @Override
        public String getMask() {
            if (this.rowSecurityState == null) {
                return null;
            }
            return this.rowSecurityState.mask;
        }

        public void setMask(String mask) {
            if (this.rowSecurityState == null) {
                if (mask == null) {
                    return;
                }
                this.rowSecurityState = new RowSecurityState();
            }
            this.rowSecurityState.mask = mask;
        }

        @Override
        public Integer getOrder() {
            if (this.rowSecurityState == null) {
                return null;
            }
            return this.rowSecurityState.order;
        }

        public void setOrder(Integer order) {
            if (this.rowSecurityState == null) {
                if (order == null) {
                    return;
                }
                this.rowSecurityState = new RowSecurityState();
            }
            this.rowSecurityState.order = order;
        }

        public Object getResolvedCondition() {
            if (this.rowSecurityState == null) {
                return null;
            }
            if (this.rowSecurityState.resolvedCondition != null) {
                return this.rowSecurityState.resolvedCondition.get();
            }
            return null;
        }

        public void setResolvedCondition(Object resolvedCondition) {
            if (this.rowSecurityState == null) {
                this.rowSecurityState = new RowSecurityState();
            }
            this.rowSecurityState.resolvedCondition = new SoftReference<Object>(resolvedCondition);
        }

        public Object getResolvedMask() {
            if (this.rowSecurityState == null) {
                return null;
            }
            if (this.rowSecurityState.resolvedMask != null) {
                return this.rowSecurityState.resolvedMask.get();
            }
            return null;
        }

        public void setResolvedMask(Object resolvedMask) {
            if (this.rowSecurityState == null) {
                this.rowSecurityState = new RowSecurityState();
            }
            this.rowSecurityState.resolvedMask = new SoftReference<Object>(resolvedMask);
        }

        @Override
        public Boolean getConstraint() {
            if (this.rowSecurityState == null) {
                return null;
            }
            return this.rowSecurityState.constraint;
        }

        public void setConstraint(Boolean constraint) {
            if (this.rowSecurityState == null) {
                if (constraint == null) {
                    return;
                }
                this.rowSecurityState = new RowSecurityState();
            }
            this.rowSecurityState.constraint = constraint;
        }
    }

    private static class RowSecurityState {
        private String condition;
        private volatile SoftReference<Object> resolvedCondition;
        private String mask;
        private volatile SoftReference<Object> resolvedMask;
        private Integer order;
        private Boolean constraint;

        private RowSecurityState() {
        }
    }

    public static class ResourceKey
    implements Comparable<ResourceKey> {
        private String name;
        private DataPolicy.ResourceType type;

        public int hashCode() {
            return Objects.hash(new Object[]{this.name.toLowerCase(), this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ResourceKey)) {
                return false;
            }
            ResourceKey other = (ResourceKey)obj;
            return this.name.equalsIgnoreCase(other.name) && Objects.equals((Object)this.type, (Object)other.type);
        }

        static ResourceKey of(String name, DataPolicy.ResourceType type) {
            ResourceKey key = new ResourceKey();
            key.name = name;
            key.type = type == null ? DataPolicy.ResourceType.DATABASE : type;
            return key;
        }

        public String getName() {
            return this.name;
        }

        public DataPolicy.ResourceType getType() {
            return this.type;
        }

        @Override
        public int compareTo(ResourceKey other) {
            int result = String.CASE_INSENSITIVE_ORDER.compare(this.name, other.name);
            if (result == 0) {
                return this.type.compareTo(other.type);
            }
            return result;
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.name;
        }
    }
}

