/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Database;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.Permission;
import org.teiid.metadata.Policy;

public class Role
extends AbstractMetadataRecord {
    private static final long serialVersionUID = 1379125260214964302L;
    private List<String> mappedRoles;
    private boolean anyAuthenticated;
    private Map<ResourceKey, Permission> grants = new LinkedHashMap<ResourceKey, Permission>();
    private Map<ResourceKey, Map<String, Policy>> policies = new LinkedHashMap<ResourceKey, Map<String, Policy>>();

    public Role(String name) {
        super.setName(name);
    }

    public List<String> getMappedRoles() {
        if (this.mappedRoles != null) {
            return new ArrayList<String>(this.mappedRoles);
        }
        return this.mappedRoles;
    }

    public void setMappedRoles(List<String> mapped) {
        this.mappedRoles = new ArrayList<String>(mapped);
    }

    public boolean isAnyAuthenticated() {
        return this.anyAuthenticated;
    }

    public void setAnyAuthenticated(boolean b) {
        this.anyAuthenticated = b;
    }

    public Map<ResourceKey, Permission> getGrants() {
        return this.grants;
    }

    public Map<ResourceKey, Map<String, Policy>> getPolicies() {
        return this.policies;
    }

    public void addGrant(Permission grant) {
        if (grant == null) {
            return;
        }
        ResourceKey key = ResourceKey.of(grant.getResourceName(), grant.getResourceType());
        Permission previous = this.grants.get(key);
        if (previous == null) {
            this.grants.put(key, grant);
        } else {
            if (grant.getMask() != null) {
                if (previous.getMask() != null) {
                    throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60035, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60035, new Object[]{grant.getMask(), previous.getMask()}));
                }
                previous.setMask(grant.getMask());
                previous.setMaskOrder(grant.getMaskOrder());
            }
            if (grant.getCondition() != null) {
                if (previous.getCondition() != null) {
                    throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60036, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60036, new Object[]{grant.getCondition(), previous.getCondition()}));
                }
                previous.setCondition(previous.getCondition(), grant.isConditionAConstraint());
            }
            previous.appendPrivileges(grant.getPrivileges());
        }
    }

    public void removeGrant(Permission toRemoveGrant) {
        if (toRemoveGrant == null) {
            return;
        }
        ResourceKey key = ResourceKey.of(toRemoveGrant.getResourceName(), toRemoveGrant.getResourceType());
        Permission previous = this.grants.get(key);
        if (previous == null) {
            this.grants.put(key, toRemoveGrant);
        } else {
            if (toRemoveGrant.getMask() != null && previous.getMask() != null) {
                previous.setMask(null);
                previous.setMaskOrder(null);
            }
            if (toRemoveGrant.getCondition() != null && previous.getCondition() != null) {
                previous.setCondition(null, null);
            }
            previous.removePrivileges(toRemoveGrant.getRevokePrivileges());
            if (previous.getPrivileges().isEmpty() && previous.getRevokePrivileges().isEmpty() && previous.getCondition() == null && previous.getMask() == null) {
                this.grants.remove(key);
            }
        }
    }

    public void addPolicy(Policy policy) {
        ResourceKey key = ResourceKey.of(policy.getResourceName(), policy.getResourceType());
        Map resourcePolicies = this.policies.computeIfAbsent(key, k -> new LinkedHashMap());
        if (resourcePolicies.put(policy.getName(), policy) != null) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60041, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60041, new Object[]{policy.getName(), this.getName(), policy.getResourceName()}));
        }
    }

    public void removePolicy(Policy policy) {
        ResourceKey key = ResourceKey.of(policy.getResourceName(), policy.getResourceType());
        Map<String, Policy> resourcePolicies = this.policies.get(key);
        if (resourcePolicies == null) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60042, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60042, new Object[]{policy.getName(), this.getName(), policy.getResourceName()}));
        }
        if (resourcePolicies.remove(policy.getName()) == null) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60042, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60042, new Object[]{policy.getName(), this.getName(), policy.getResourceName()}));
        }
    }

    public void mergeInto(Role existing) {
        for (Permission permission : this.grants.values()) {
            existing.addGrant(permission);
        }
        for (Map map : this.policies.values()) {
            for (Policy policy : map.values()) {
                existing.addPolicy(policy);
            }
        }
    }

    public static class ResourceKey
    implements Comparable<ResourceKey> {
        private String name;
        private Database.ResourceType type;

        public int hashCode() {
            return Objects.hash(new Object[]{this.name == null ? Integer.valueOf(13) : this.name.toLowerCase(), this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ResourceKey)) {
                return false;
            }
            ResourceKey other = (ResourceKey)obj;
            return this.name.equalsIgnoreCase(other.name) && Objects.equals((Object)this.type, (Object)other.type);
        }

        public static ResourceKey of(String name, Database.ResourceType type) {
            ResourceKey key = new ResourceKey();
            key.name = name;
            key.type = type == null ? Database.ResourceType.DATABASE : type;
            return key;
        }

        public String getName() {
            return this.name;
        }

        public Database.ResourceType getType() {
            return this.type;
        }

        @Override
        public int compareTo(ResourceKey other) {
            int result = String.CASE_INSENSITIVE_ORDER.compare(this.name, other.name);
            if (result == 0) {
                return this.type.compareTo(other.type);
            }
            return result;
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.name;
        }
    }
}

