/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDBImport;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.EntryMetaData;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;

public class TestVDBUtility {
    public static void validateVDB(VDBMetaData vdb) {
        Assert.assertEquals((Object)"myVDB", (Object)vdb.getName());
        Assert.assertEquals((Object)"vdb description", (Object)vdb.getDescription());
        Assert.assertEquals((String)"connection-type", (Object)"NONE", (Object)vdb.getConnectionType().name());
        Assert.assertEquals((Object)"1", (Object)vdb.getVersion());
        Assert.assertEquals((Object)"vdb-value", (Object)vdb.getPropertyValue("vdb-property"));
        Assert.assertEquals((Object)"vdb-value2", (Object)vdb.getPropertyValue("vdb-property2"));
        Assert.assertNotNull((Object)vdb.getModel("model-one"));
        Assert.assertNotNull((Object)vdb.getModel("model-two"));
        Assert.assertNull((Object)vdb.getModel("model-unknown"));
        Assert.assertEquals((long)1L, (long)vdb.getVDBImports().size());
        VDBImport vdbImport = (VDBImport)vdb.getVDBImports().get(0);
        Assert.assertEquals((Object)"x", (Object)vdbImport.getName());
        Assert.assertEquals((Object)"2", (Object)vdbImport.getVersion());
        ModelMetaData modelOne = vdb.getModel("model-one");
        Assert.assertEquals((Object)"model-one", (Object)modelOne.getName());
        Assert.assertEquals((Object)"s1", modelOne.getSourceNames().get(0));
        Assert.assertEquals((Object)Model.Type.PHYSICAL, (Object)modelOne.getModelType());
        Assert.assertEquals((Object)"model-value-override", (Object)modelOne.getPropertyValue("model-prop"));
        Assert.assertFalse((boolean)modelOne.isVisible());
        Assert.assertEquals((Object)"model description", (Object)modelOne.getDescription());
        Assert.assertEquals((Object)"DDL", modelOne.getSourceMetadataType().get(0));
        Assert.assertEquals((Object)"DDL Here", modelOne.getSourceMetadataText().get(0));
        Assert.assertEquals((Object)"OTHER", modelOne.getSourceMetadataType().get(1));
        Assert.assertEquals((Object)"other text", modelOne.getSourceMetadataText().get(1));
        ModelMetaData modelTwo = vdb.getModel("model-two");
        Assert.assertEquals((Object)"model-two", (Object)modelTwo.getName());
        Assert.assertTrue((boolean)modelTwo.getSourceNames().contains("s1"));
        Assert.assertTrue((boolean)modelTwo.getSourceNames().contains("s2"));
        Assert.assertEquals((Object)Model.Type.VIRTUAL, (Object)modelTwo.getModelType());
        Assert.assertEquals((Object)"model-value", (Object)modelTwo.getPropertyValue("model-prop"));
        Assert.assertEquals((Object)"DDL", modelTwo.getSourceMetadataType().get(0));
        Assert.assertEquals((Object)"DDL Here", modelTwo.getSourceMetadataText().get(0));
        Assert.assertTrue((boolean)vdb.getValidityErrors().contains("There is an error in VDB"));
        List translators = vdb.getOverrideTranslators();
        Assert.assertTrue((translators.size() == 1 ? 1 : 0) != 0);
        Translator translator = (Translator)translators.get(0);
        Assert.assertEquals((Object)"oracleOverride", (Object)translator.getName());
        Assert.assertEquals((Object)"oracle", (Object)translator.getType());
        Assert.assertEquals((Object)"my-value", (Object)translator.getPropertyValue("my-property"));
        Assert.assertEquals((Object)"hello world", (Object)translator.getDescription());
        List roles = vdb.getDataPolicies();
        Assert.assertTrue((roles.size() == 1 ? 1 : 0) != 0);
        DataPolicyMetadata role = (DataPolicyMetadata)vdb.getDataPolicyMap().get("roleOne");
        Assert.assertTrue((boolean)role.isGrantAll());
        Assert.assertTrue((boolean)role.isAllowCreateTemporaryTables());
        Assert.assertEquals((Object)"roleOne described", (Object)role.getDescription());
        Assert.assertNotNull((Object)role.getMappedRoleNames());
        Assert.assertTrue((boolean)role.getMappedRoleNames().contains("ROLE1"));
        Assert.assertTrue((boolean)role.getMappedRoleNames().contains("ROLE2"));
        List permissions = role.getPermissions();
        Assert.assertEquals((long)4L, (long)permissions.size());
        boolean lang = false;
        for (DataPolicy.DataPermission p : permissions) {
            if (p.getAllowLanguage() != null) {
                Assert.assertTrue((boolean)p.getAllowLanguage());
                Assert.assertEquals((Object)"javascript", (Object)p.getResourceName());
                lang = true;
                continue;
            }
            if (p.getResourceName().equalsIgnoreCase("myTable.T1")) {
                Assert.assertTrue((boolean)p.getAllowRead());
                Assert.assertNull((Object)p.getAllowDelete());
                Assert.assertFalse((boolean)p.getConstraint());
                continue;
            }
            if (p.getResourceName().equalsIgnoreCase("myTable.T2.col1")) {
                Assert.assertEquals((Object)"col2", (Object)p.getMask());
                Assert.assertEquals((long)1L, (long)p.getOrder().intValue());
                continue;
            }
            Assert.assertFalse((boolean)p.getAllowRead());
            Assert.assertTrue((boolean)p.getAllowDelete());
            Assert.assertEquals((Object)"col1 = user()", (Object)p.getCondition());
            Assert.assertTrue((boolean)p.getConstraint());
        }
        Assert.assertTrue((boolean)lang);
    }

    public static VDBMetaData buildVDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("myVDB");
        vdb.setDescription("vdb description");
        vdb.setConnectionType("NONE");
        vdb.setVersion(1);
        vdb.addProperty("vdb-property", "vdb-value");
        vdb.addProperty("vdb-property2", "vdb-value2");
        VDBImportMetadata vdbImport = new VDBImportMetadata();
        vdbImport.setName("x");
        vdbImport.setVersion("2");
        vdb.getVDBImports().add(vdbImport);
        ModelMetaData modelOne = new ModelMetaData();
        modelOne.setName("model-one");
        modelOne.addSourceMapping("s1", "translator", "java:mybinding");
        modelOne.setModelType(Model.Type.PHYSICAL);
        modelOne.addProperty("model-prop", "model-value");
        modelOne.addProperty("model-prop", "model-value-override");
        modelOne.setVisible(false);
        modelOne.addMessage("ERROR", "There is an error in VDB");
        modelOne.addMessage("INFO", "Nothing to see here");
        modelOne.setDescription("model description");
        modelOne.addSourceMetadata("DDL", "DDL Here");
        modelOne.addSourceMetadata("OTHER", "other text");
        vdb.addModel(modelOne);
        ModelMetaData modelTwo = new ModelMetaData();
        modelTwo.setName("model-two");
        modelTwo.addSourceMapping("s1", "translator", "java:binding-one");
        modelTwo.addSourceMapping("s2", "translator", "java:binding-two");
        modelTwo.setModelType(Model.Type.VIRTUAL);
        modelTwo.addProperty("model-prop", "model-value");
        modelTwo.addSourceMetadata("DDL", "DDL Here");
        vdb.addModel(modelTwo);
        VDBTranslatorMetaData t1 = new VDBTranslatorMetaData();
        t1.setName("oracleOverride");
        t1.setType("oracle");
        t1.setDescription("hello world");
        t1.addProperty("my-property", "my-value");
        ArrayList<VDBTranslatorMetaData> list = new ArrayList<VDBTranslatorMetaData>();
        list.add(t1);
        vdb.setOverrideTranslators(list);
        DataPolicyMetadata roleOne = new DataPolicyMetadata();
        roleOne.setName("roleOne");
        roleOne.setDescription("roleOne described");
        roleOne.setAllowCreateTemporaryTables(Boolean.valueOf(true));
        roleOne.setGrantAll(true);
        DataPolicyMetadata.PermissionMetaData perm1 = new DataPolicyMetadata.PermissionMetaData();
        perm1.setResourceName("myTable.T1");
        perm1.setAllowRead(Boolean.valueOf(true));
        perm1.setCondition("col1 = user()");
        perm1.setConstraint(Boolean.valueOf(false));
        roleOne.addPermission(new DataPolicyMetadata.PermissionMetaData[]{perm1});
        DataPolicyMetadata.PermissionMetaData perm2 = new DataPolicyMetadata.PermissionMetaData();
        perm2.setResourceName("myTable.T2");
        perm2.setAllowRead(Boolean.valueOf(false));
        perm2.setAllowDelete(Boolean.valueOf(true));
        perm2.setCondition("col1 = user()");
        perm2.setConstraint(Boolean.valueOf(true));
        roleOne.addPermission(new DataPolicyMetadata.PermissionMetaData[]{perm2});
        DataPolicyMetadata.PermissionMetaData perm3 = new DataPolicyMetadata.PermissionMetaData();
        perm3.setResourceName("javascript");
        perm3.setAllowLanguage(Boolean.valueOf(true));
        roleOne.addPermission(new DataPolicyMetadata.PermissionMetaData[]{perm3});
        DataPolicyMetadata.PermissionMetaData perm4 = new DataPolicyMetadata.PermissionMetaData();
        perm4.setResourceName("myTable.T2.col1");
        perm4.setMask("col2");
        perm4.setOrder(Integer.valueOf(1));
        roleOne.addPermission(new DataPolicyMetadata.PermissionMetaData[]{perm4});
        roleOne.setMappedRoleNames(Arrays.asList("ROLE1", "ROLE2"));
        vdb.addDataPolicy(roleOne);
        EntryMetaData em = new EntryMetaData();
        em.setPath("/path-one");
        em.setDescription("entry one");
        em.addProperty("entryone", "1");
        vdb.getEntries().add(em);
        EntryMetaData em2 = new EntryMetaData();
        em2.setPath("/path-two");
        vdb.getEntries().add(em2);
        return vdb;
    }
}

