/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.util.Arrays;
import org.teiid.core.types.BlobType;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.PropertiesUtils;

public final class BinaryType
implements Comparable<BinaryType> {
    private byte[] bytes;

    public BinaryType(byte[] bytes) {
        Assertion.isNotNull(bytes);
        this.bytes = bytes;
    }

    public byte[] getBytesDirect() {
        return this.bytes;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public byte getByte(int index) {
        return this.bytes[index];
    }

    public int getLength() {
        return this.bytes.length;
    }

    @Override
    public int compareTo(BinaryType o) {
        int len1 = this.getLength();
        int len2 = o.getLength();
        int n = Math.min(len1, len2);
        for (int i = 0; i < n; ++i) {
            int b1 = this.bytes[i] & 0xFF;
            int b2 = o.bytes[i] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BinaryType)) {
            return false;
        }
        BinaryType other = (BinaryType)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public String toString() {
        return PropertiesUtils.toHex(this.bytes);
    }

    public BlobType toBlob() {
        return new BlobType(BlobType.createBlob(this.bytes));
    }
}

