/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class NumberToFloatTransform
extends Transform {
    private Class<?> sourceType;
    private boolean isNarrowing;
    private boolean isLossy;

    public NumberToFloatTransform(Class<?> sourceType, boolean isNarrowing, boolean isLossy) {
        this.sourceType = sourceType;
        this.isNarrowing = isNarrowing;
        this.isLossy = isLossy;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE));
        }
        return Float.valueOf(((Number)value).floatValue());
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.FLOAT;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing || this.isLossy;
    }
}

