/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.basic.NumberToNumberTransform;

public class NumberToShortTransform
extends NumberToNumberTransform {
    private boolean isNarrowing;

    public NumberToShortTransform(Class<?> sourceType, boolean isNarrowing) {
        super((short)Short.MIN_VALUE, (short)Short.MAX_VALUE, sourceType);
        this.isNarrowing = isNarrowing;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value);
        }
        return ((Number)value).shortValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.SHORT;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing;
    }
}

