/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.Cryptor;
import org.teiid.core.crypto.SymmetricCryptor;

public class TestEncryptDecrypt {
    private static final String ALPHA_U = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String ALPHA_L = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toLowerCase();
    private static final String NUMBERS = "0123456789";
    private static final String MISC_CHAR = "<>,.:;'{}[][]|`~!@#$%^&*()_+-=";
    private static final String CLEARTEXT = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" + ALPHA_L + "0123456789" + "<>,.:;'{}[][]|`~!@#$%^&*()_+-=";
    private static Cryptor cryptor;

    @BeforeClass
    public static void oneTimeSetup() throws CryptoException, IOException {
        cryptor = SymmetricCryptor.getSymmectricCryptor((URL)TestEncryptDecrypt.class.getResource("/teiid.keystore"));
    }

    public void helpTestEncryptDecrypt(String cleartext) throws CryptoException {
        byte[] ciphertext = cryptor.encrypt(cleartext.getBytes(Charset.forName("UTF-8")));
        byte[] cleartext2 = cryptor.decrypt(ciphertext);
        Assert.assertArrayEquals((byte[])cleartext.getBytes(Charset.forName("UTF-8")), (byte[])cleartext2);
    }

    @Test
    public void testPos_EncryptDecryptLongString() throws CryptoException {
        this.helpTestEncryptDecrypt(CLEARTEXT);
    }

    @Test
    public void testPos_EncryptDecryptHalfLongString() throws CryptoException {
        this.helpTestEncryptDecrypt(CLEARTEXT.substring(0, CLEARTEXT.length() / 2));
    }

    @Test
    public void testPos_EncryptDecryptStringsOfVariousLengths() throws CryptoException {
        for (int k = 1; k < CLEARTEXT.length() / 4; ++k) {
            String cleartext = CLEARTEXT.substring(k, k + k);
            this.helpTestEncryptDecrypt(cleartext);
        }
    }

    @Test
    public void testPos_EncryptDecryptStringsOfBlanks() throws CryptoException {
        String BLANKS = "          ";
        for (int k = 1; k < BLANKS.length(); ++k) {
            String cleartext = BLANKS.substring(0, k);
            this.helpTestEncryptDecrypt(cleartext);
        }
    }

    @Test
    public void testNeg_DecryptNullString() throws Exception {
        try {
            cryptor.decrypt(null);
            Assert.fail((String)"expected exception");
        }
        catch (CryptoException cryptoException) {
            // empty catch block
        }
    }

    @Test
    public void testLongEncryption() throws Exception {
        this.helpTestEncryptDecrypt(CLEARTEXT + CLEARTEXT + CLEARTEXT);
    }

    @Test
    public void testSymmetricEncryptionWithRandomKey() throws Exception {
        SymmetricCryptor randomSymCryptor = SymmetricCryptor.getSymmectricCryptor((boolean)true);
        ArrayList<String> test = new ArrayList<String>(Arrays.asList(ALPHA_L, ALPHA_U, CLEARTEXT, NUMBERS));
        Object result = randomSymCryptor.sealObject(test);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(result);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        result = ois.readObject();
        ArrayList clearObject = (ArrayList)randomSymCryptor.unsealObject(result);
        Assert.assertEquals(test, (Object)clearObject);
        SymmetricCryptor cryptor1 = SymmetricCryptor.getSymmectricCryptor((byte[])randomSymCryptor.getEncodedKey(), (boolean)true);
        clearObject = (ArrayList)cryptor1.unsealObject(result);
        Assert.assertEquals(test, (Object)clearObject);
    }
}

