/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.basic.NumberToNumberTransform;

public class NumberToLongTransform
extends NumberToNumberTransform {
    private boolean isNarrowing;
    private boolean isLossy;

    public NumberToLongTransform(Class<?> sourceType, boolean isNarrowing, boolean isLossy) {
        super(Long.MIN_VALUE, Long.MAX_VALUE, sourceType);
        this.isNarrowing = isNarrowing;
        this.isLossy = isLossy;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value);
        }
        return ((Number)value).longValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.LONG;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing || this.isLossy;
    }
}

