/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.teiid.core.types.StandardXMLTranslator;

public class TestXMLStreamSourceTranslator
extends TestCase {
    private static final String sourceXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Books:bookCollection xmlns:Books=\"http://www.metamatrix.com/XMLSchema/DataSets/Books\">\r\n   <book isbn=\"0-7356-0877-6\">\r\n      <title>After the Gold Rush</title>\r\n      <subtitle>Creating a True Profession of Software Engineering</subtitle>\r\n      <edition>1</edition>\r\n      <authors>\r\n         <author>McConnell</author>\r\n      </authors>\r\n      <publishingInformation>\r\n         <publisher>Microsoft Press</publisher>\r\n         <publishDate>1999</publishDate>\r\n      </publishingInformation>\r\n   </book>\r\n   <book isbn=\"1-55615-484-4\">\r\n      <title>Code Complete</title>\r\n      <subtitle>A Practical Handbook of Software Construction</subtitle>\r\n      <edition>1</edition>\r\n      <authors>\r\n         <author>McConnell</author>\r\n      </authors>\r\n      <publishingInformation>\r\n         <publisher>Microsoft Press</publisher>\r\n         <publishDate>1993</publishDate>\r\n      </publishingInformation>\r\n   </book>\r\n   <book isbn=\"1-556-15900-5\">\r\n      <title>Rapid Development</title>\r\n      <subtitle>Taming Wild Software Schedules</subtitle>\r\n      <edition>1</edition>\r\n      <authors>\r\n         <author>McConnell</author>\r\n      </authors>\r\n      <publishingInformation>\r\n         <publisher>Microsoft Press</publisher>\r\n         <publishDate>1996</publishDate>\r\n      </publishingInformation>\r\n   </book>\r\n</Books:bookCollection>";

    public void testStreamSourceWithStream() throws Exception {
        StandardXMLTranslator translator = new StandardXMLTranslator((Source)new StreamSource(new StringReader(sourceXML)));
        this.compareDocuments(sourceXML, translator.getString());
    }

    private void compareDocuments(String expectedDoc, String actualDoc) {
        StringTokenizer tokens1 = new StringTokenizer(expectedDoc, "\r\n");
        StringTokenizer tokens2 = new StringTokenizer(actualDoc, "\n");
        while (tokens1.hasMoreTokens()) {
            String token1 = tokens1.nextToken().trim();
            if (!tokens2.hasMoreTokens()) {
                TestXMLStreamSourceTranslator.fail((String)("XML doc mismatch: expected=" + token1 + "\nactual=none"));
            }
            String token2 = tokens2.nextToken().trim();
            TestXMLStreamSourceTranslator.assertEquals((String)"XML doc mismatch: ", (String)token1, (String)token2);
        }
        if (tokens2.hasMoreTokens()) {
            TestXMLStreamSourceTranslator.fail((String)("XML doc mismatch: expected=none\nactual=" + tokens2.nextToken().trim()));
        }
    }
}

