/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.sql.SQLXML;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.types.basic.StringToSQLXMLTransform;

public class TestStringToXmlTransform {
    @Test
    public void testGoodXML() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><customer>\n<name>ABC</name><age>32</age></customer>";
        StringToSQLXMLTransform transform = new StringToSQLXMLTransform();
        SQLXML xmlValue = (SQLXML)transform.transformDirect((Object)xml);
        Assert.assertEquals((Object)xml.replaceAll("[\r]", ""), (Object)xmlValue.getString().replaceAll("[\r]", ""));
    }

    @Test
    public void testGoodElement() throws Exception {
        String xml = "<customer>\n<name>ABC</name><age>32</age></customer>";
        StringToSQLXMLTransform transform = new StringToSQLXMLTransform();
        XMLType xmlValue = (XMLType)transform.transformDirect((Object)xml);
        Assert.assertEquals((Object)xml.replaceAll("[\r]", ""), (Object)xmlValue.getString().replaceAll("[\r]", ""));
        Assert.assertEquals((Object)XMLType.Type.ELEMENT, (Object)xmlValue.getType());
    }

    @Test(expected=TransformationException.class)
    public void testBadXML() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><customer>\n<name>ABC</name><age>32</age><customer>";
        StringToSQLXMLTransform transform = new StringToSQLXMLTransform();
        transform.transformDirect((Object)xml);
    }
}

