/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.SqlUtil;

public class TestSqlUtil {
    public void helpTest(String sql, boolean isUpdate) {
        boolean actual = SqlUtil.isUpdateSql((String)sql);
        Assert.assertEquals((Object)isUpdate, (Object)actual);
    }

    @Test
    public void testSelect() {
        this.helpTest("SELECT x FROM y", false);
    }

    @Test
    public void testInsert() {
        this.helpTest("Insert INTO g (a) VALUES (1)", true);
    }

    @Test
    public void testUpdate() {
        this.helpTest("upDate x set a=5", true);
    }

    @Test
    public void testDelete() {
        this.helpTest("delete FROM x", true);
    }

    @Test
    public void testInsertWithWhitespace() {
        this.helpTest("\nINSERT INTO g (a) VALUES (1)", true);
    }

    @Test
    public void testExec() {
        this.helpTest("exec sq1()", false);
    }

    @Test
    public void testXquery() {
        this.helpTest("<i/>", false);
    }

    @Test
    public void testSelectInto1() {
        this.helpTest("SELECT x INTO z FROM y", true);
    }

    @Test
    public void testSelectInto2() {
        this.helpTest("SELECT x, INTOz FROM y", false);
    }

    @Test
    public void testSelectInto3() {
        this.helpTest("SELECT x into z FROM y", true);
    }

    @Test
    public void testSelectInto4() {
        this.helpTest("SELECT x into z", true);
    }

    @Test
    public void testSelectInto5() {
        this.helpTest("SELECT x, ' into ' from z", false);
    }

    @Test
    public void testCreate() {
        this.helpTest(" create table x", true);
    }

    @Test
    public void testDrop() {
        this.helpTest("/* */ drop table x", true);
    }
}

