/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.core.util.UnitTestUtil;

public class TestReaderInputStream {
    @Test
    public void testUTF8() throws Exception {
        int value;
        FileInputStream fis = new FileInputStream(UnitTestUtil.getTestDataFile("legal_notice.xml"));
        ReaderInputStream ris = new ReaderInputStream((Reader)new FileReader(UnitTestUtil.getTestDataFile("legal_notice.xml")), Charset.forName("UTF-8"));
        do {
            value = fis.read();
            Assert.assertEquals((long)value, (long)ris.read());
        } while (value != -1);
    }

    @Test
    public void testUTF16() throws Exception {
        String actual = "!?abc";
        ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(actual), Charset.forName("UTF-16").newEncoder(), 2);
        byte[] result = ObjectConverterUtil.convertToByteArray((InputStream)ris);
        String resultString = new String(result, "UTF-16");
        Assert.assertEquals((Object)resultString, (Object)actual);
    }

    @Test
    public void testASCII() throws Exception {
        String actual = "!?abc";
        ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(actual), Charset.forName("US-ASCII").newEncoder(), 1);
        byte[] result = ObjectConverterUtil.convertToByteArray((InputStream)ris);
        String resultString = new String(result, "US-ASCII");
        Assert.assertEquals((Object)resultString, (Object)actual);
    }

    @Test(expected=IOException.class)
    public void testASCIIError() throws Exception {
        String actual = "!?abc\uffffafs";
        Charset cs = Charset.forName("ASCII");
        ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(actual), cs.newEncoder(), 1);
        ObjectConverterUtil.convertToByteArray((InputStream)ris);
    }
}

