/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.sql.Clob;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JsonType;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class JsonToClobTransform
extends Transform {
    @Override
    public Object transformDirect(Object value) throws TransformationException {
        JsonType json = (JsonType)value;
        ClobType clob = new ClobType((Clob)json.getReference());
        clob.setType(ClobType.Type.JSON);
        return clob;
    }

    @Override
    public Class<?> getSourceType() {
        return DataTypeManager.DefaultDataClasses.JSON;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.CLOB;
    }

    @Override
    public boolean isExplicit() {
        return false;
    }
}

