/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.math.BigDecimal;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class FloatingNumberToBigIntegerTransform
extends Transform {
    private Class<?> sourceType;

    public FloatingNumberToBigIntegerTransform(Class<?> sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        return BigDecimal.valueOf(((Number)value).doubleValue()).toBigInteger();
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.BIG_INTEGER;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

