/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.StringUtil;

public final class PropertiesUtils {
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Properties clone(Properties props) {
        return PropertiesUtils.clone(props, null, false);
    }

    public static Properties clone(Properties props, Properties defaults, boolean deepClone) {
        Properties result = null;
        if (defaults != null) {
            if (deepClone) {
                defaults = PropertiesUtils.clone(defaults);
            }
            result = new Properties(defaults);
        } else {
            result = new Properties();
        }
        PropertiesUtils.putAll(result, props);
        return result;
    }

    public static void putAll(Properties addToThis, Properties withThese) {
        if (withThese != null && addToThis != null) {
            Enumeration<?> enumeration = withThese.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propName = (String)enumeration.nextElement();
                Object propValue = withThese.get(propName);
                if (propValue == null) {
                    propValue = withThese.getProperty(propName);
                }
                if (propValue == null) continue;
                addToThis.put(propName, propValue);
            }
        }
    }

    public static int getIntProperty(Properties props, String propName, int defaultValue) throws InvalidPropertyException {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stringVal);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(CorePlugin.Event.TEIID10037, propName, stringVal, Integer.class, e);
        }
    }

    public static long getLongProperty(Properties props, String propName, long defaultValue) {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Long.parseLong(stringVal);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(CorePlugin.Event.TEIID10038, propName, stringVal, Long.class, e);
        }
    }

    public static float getFloatProperty(Properties props, String propName, float defaultValue) {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(stringVal);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(CorePlugin.Event.TEIID10039, propName, stringVal, Float.class, e);
        }
    }

    public static double getDoubleProperty(Properties props, String propName, double defaultValue) {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(stringVal);
        }
        catch (NumberFormatException e) {
            throw new InvalidPropertyException(CorePlugin.Event.TEIID10040, propName, stringVal, Double.class, e);
        }
    }

    public static boolean getBooleanProperty(Properties props, String propName, boolean defaultValue) {
        String stringVal = props.getProperty(propName);
        if (stringVal == null) {
            return defaultValue;
        }
        if ((stringVal = stringVal.trim()).length() == 0) {
            return defaultValue;
        }
        return Boolean.valueOf(stringVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadHeader(String fileName) throws IOException {
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(fileName);
            br = new BufferedReader(fr);
            String header = br.readLine();
            if (header != null && header.indexOf(35) == 0) {
                header = header.substring(1);
            }
            String string = header;
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(String fileName) throws IOException {
        InputStream is = null;
        try {
            Properties props = new Properties();
            is = new FileInputStream(fileName);
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static Properties loadFromURL(URL url) throws MalformedURLException, IOException {
        Properties result = new Properties();
        InputStream is = null;
        try {
            is = url.openStream();
            result.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadAsResource(Class clazz, String resourceName) throws IOException {
        InputStream is = null;
        Properties configProps = new Properties();
        try {
            is = clazz.getResourceAsStream(resourceName);
            ArgCheck.isNotNull(is);
            if (is != null) {
                configProps.load(is);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return configProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(String fileName, Properties props, String header) throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(fileName);
            props.store(stream, header);
            stream.flush();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(String fileName, Properties props) throws IOException {
        FileOutputStream stream = null;
        PrintStream writer = null;
        try {
            stream = new FileOutputStream(fileName);
            writer = new PrintStream(stream);
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                names.add(name);
            }
            Collections.sort(names);
            for (String name : names) {
                String value = props.getProperty(name);
                StringBuffer sb = new StringBuffer();
                sb.append(name);
                sb.append("=");
                sb.append(value);
                writer.println(sb.toString());
            }
            writer.flush();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String saveConvert(String theString, boolean escapeSpace) {
        if (theString == null) {
            return "";
        }
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertiesUtils.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertiesUtils.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertiesUtils.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertiesUtils.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(PropertiesUtils.toHex(b >>> 4));
            sb.append(PropertiesUtils.toHex(b));
        }
        return sb.toString();
    }

    public static byte[] fromHex(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        byte[] result = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); ++i) {
            int charValue = hex.charAt(i);
            if (charValue >= 48 && charValue <= 57) {
                charValue -= 48;
            } else if (charValue >= 65 && charValue <= 70) {
                charValue -= 55;
            } else if (charValue >= 97 && charValue <= 102) {
                charValue -= 87;
            } else {
                throw new IllegalArgumentException();
            }
            if (i % 2 == 0) {
                int n = i / 2;
                result[n] = (byte)(result[n] | charValue << 4);
                continue;
            }
            int n = i / 2;
            result[n] = (byte)(result[n] | charValue);
        }
        return result;
    }

    public static void toHex(StringBuilder sb, InputStream is) throws IOException {
        int i = 0;
        while ((i = is.read()) != -1) {
            byte b = (byte)i;
            sb.append(PropertiesUtils.toHex(b >>> 4));
            sb.append(PropertiesUtils.toHex(b));
        }
    }

    public static Properties resolveNestedProperties(Properties original) {
        Enumeration<?> e = original.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = original.getProperty(key);
            if (value == null) continue;
            boolean matched = true;
            boolean modified = false;
            while (matched) {
                int start;
                int end = start = value.indexOf("${");
                if (start != -1) {
                    end = value.indexOf(125, start);
                }
                if (!(matched = start != -1 && end != -1)) continue;
                String nestedkey = value.substring(start + 2, end);
                String nestedvalue = original.getProperty(nestedkey);
                if (key.equals(nestedkey)) {
                    matched = false;
                    continue;
                }
                if (nestedvalue == null) {
                    throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10042, CorePlugin.Util.gs(CorePlugin.Event.TEIID10042, nestedkey));
                }
                value = value.substring(0, start) + nestedvalue + value.substring(end + 1);
                modified = true;
            }
            if (!modified) continue;
            original.setProperty(key, value);
        }
        return original;
    }

    public static void setBeanProperties(Object bean, Properties props, String prefix) {
        PropertiesUtils.setBeanProperties(bean, props, prefix, false);
    }

    public static void setBeanProperties(Object bean, Properties props, String prefix, boolean caseSensitive) {
        Map<Object, Object> map = props;
        if (!caseSensitive) {
            map = PropertiesUtils.caseInsensitiveProps(props);
        }
        Method[] methods = bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Object propertyValue;
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
            String propertyName = methodName.substring(3);
            if (prefix != null) {
                propertyName = caseSensitive ? prefix + "." + Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1, propertyName.length()) : prefix + "." + propertyName;
            }
            if ((propertyValue = map.get(propertyName)) == null && !map.containsKey(propertyName)) continue;
            PropertiesUtils.setProperty(bean, propertyValue, method, propertyName);
        }
    }

    public static void setBeanProperty(Object bean, String name, Object value) {
        Method[] methods = bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || !StringUtil.endsWithIgnoreCase(methodName, name)) continue;
            String propertyName = methodName.substring(3);
            PropertiesUtils.setProperty(bean, value, method, propertyName);
        }
    }

    private static Class<?> setProperty(Object bean, Object value, Method method, String propertyName) {
        Class<?> argType = method.getParameterTypes()[0];
        try {
            Object[] params = new Object[]{value};
            if (value != null && !argType.isAssignableFrom(value.getClass())) {
                params = new Object[]{StringUtil.valueOf(value.toString(), argType)};
            }
            method.invoke(bean, params);
        }
        catch (Throwable e) {
            throw new InvalidPropertyException(CorePlugin.Event.TEIID10044, propertyName, value, argType, e);
        }
        return argType;
    }

    private static TreeMap<String, String> caseInsensitiveProps(Properties connectionProps) {
        TreeMap<String, String> caseInsensitive = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Enumeration<?> itr = connectionProps.propertyNames();
        while (itr.hasMoreElements()) {
            String name = (String)itr.nextElement();
            String propValue = connectionProps.getProperty(name);
            if (propValue == null && !connectionProps.containsKey(name)) continue;
            caseInsensitive.put(name, propValue);
        }
        return caseInsensitive;
    }

    public static String getHierarchicalProperty(String key, String defaultValue) {
        return PropertiesUtils.getHierarchicalProperty(key, defaultValue, String.class);
    }

    public static <T> T getHierarchicalProperty(String key, T defaultValue, Class<T> clazz) {
        String stringVal = System.getenv(key);
        if (stringVal != null && (stringVal = stringVal.trim()).length() != 0) {
            return StringUtil.valueOf(stringVal, clazz);
        }
        stringVal = System.getProperty(key);
        if (stringVal != null && (stringVal = stringVal.trim()).length() != 0) {
            return StringUtil.valueOf(stringVal, clazz);
        }
        return defaultValue;
    }

    public static Properties getCombinedProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        properties.putAll(System.getenv());
        return properties;
    }

    public static class InvalidPropertyException
    extends TeiidRuntimeException {
        private static final long serialVersionUID = 1586068295007497776L;

        public InvalidPropertyException(BundleUtil.Event event, String propertyName, Object value, Class<?> expectedType, Throwable cause) {
            super(event, cause, CorePlugin.Util.getString("InvalidPropertyException.message", propertyName, value, expectedType.getSimpleName()));
        }
    }
}

