/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.sql.rowset.serial.SerialBlob;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.GeographyType;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class TestDataTypeManager {
    public static String[] dataTypes = new String[]{"string", "char", "boolean", "byte", "short", "integer", "long", "biginteger", "float", "double", "bigdecimal", "date", "time", "timestamp", "object", "blob", "clob", "xml"};
    public static char[][] conversions = new char[][]{{'O', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'I', 'N', 'I', 'C'}, {'I', 'O', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'O', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'O', 'I', 'I', 'I', 'I', 'I', 'I', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'O', 'I', 'I', 'I', 'I', 'I', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'O', 'I', 'I', 'C', 'I', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'C', 'O', 'I', 'C', 'C', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'C', 'C', 'O', 'C', 'C', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'C', 'C', 'C', 'O', 'I', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'O', 'I', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'O', 'N', 'N', 'N', 'I', 'N', 'N', 'N'}, {'I', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'O', 'N', 'I', 'I', 'N', 'N', 'N'}, {'I', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'O', 'I', 'I', 'N', 'N', 'N'}, {'I', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'C', 'C', 'O', 'I', 'N', 'N', 'N'}, {'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'O', 'C', 'C', 'C'}, {'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'I', 'O', 'N', 'N'}, {'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'I', 'N', 'O', 'N'}, {'C', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'I', 'N', 'N', 'O'}};

    private void helpDetermineDataType(Object value, Class<?> expectedClass) {
        Class actualClass = DataTypeManager.determineDataTypeClass((Object)value);
        Assert.assertNotNull((Object)("Should never receive null when determining data type of object: " + value));
        Assert.assertEquals((String)("Mismatch in expected and actual MetaMatrix type class for [" + value + "]: "), expectedClass, (Object)actualClass);
    }

    @Test
    public void testTypeMappings() {
        Set dataTypeNames = DataTypeManager.getAllDataTypeNames();
        for (String dataTypeName : dataTypeNames) {
            Class dataTypeClass = DataTypeManager.getDataTypeClass((String)dataTypeName);
            Assert.assertNotNull((String)("Data type class was null for type " + dataTypeName), (Object)dataTypeClass);
            String dataTypeName2 = DataTypeManager.getDataTypeName((Class)dataTypeClass);
            Assert.assertEquals((String)"Name to class to name not equals: ", (Object)dataTypeName, (Object)dataTypeName2);
        }
    }

    @Test
    public void testCheckConversions() {
        for (int src = 0; src < dataTypes.length; ++src) {
            for (int tgt = 0; tgt < dataTypes.length; ++tgt) {
                char c = conversions[src][tgt];
                if (c == 'I') {
                    Assert.assertTrue((String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should be Implicit"), (boolean)DataTypeManager.isImplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]));
                    Assert.assertFalse((String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should be not be Explicit"), (boolean)DataTypeManager.isExplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]));
                    Assert.assertTrue((String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " transform should be avaialble"), (boolean)DataTypeManager.isTransformable((String)dataTypes[src], (String)dataTypes[tgt]));
                    continue;
                }
                if (c == 'C') {
                    Assert.assertFalse((String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should not be Implicit"), (boolean)DataTypeManager.isImplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]));
                    Assert.assertTrue((String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should be Explicit"), (boolean)DataTypeManager.isExplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]));
                    Assert.assertTrue((String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " transform should be avaialble"), (boolean)DataTypeManager.isTransformable((String)dataTypes[src], (String)dataTypes[tgt]));
                    continue;
                }
                if (c != 'O' && c != 'N') continue;
                Assert.assertFalse((String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should not be Implicit"), (boolean)DataTypeManager.isImplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]));
                Assert.assertFalse((String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " should not be Explicit"), (boolean)DataTypeManager.isExplicitConversion((String)dataTypes[src], (String)dataTypes[tgt]));
                Assert.assertFalse((String)("src=" + dataTypes[src] + " target=" + dataTypes[tgt] + " No transform should be avaialble"), (boolean)DataTypeManager.isTransformable((String)dataTypes[src], (String)dataTypes[tgt]));
            }
        }
    }

    @Test
    public void testDetermineDataType1() {
        this.helpDetermineDataType("abc", DataTypeManager.DefaultDataClasses.STRING);
    }

    @Test
    public void testDetermineDataType2() {
        this.helpDetermineDataType(null, DataTypeManager.DefaultDataClasses.NULL);
    }

    @Test
    public void testDetermineDataType3() throws Exception {
        URL url = new URL("http://fake");
        this.helpDetermineDataType(url, DataTypeManager.DefaultDataClasses.OBJECT);
    }

    @Test
    public void testCheckAllConversions() {
        Set allTypes = DataTypeManager.getAllDataTypeNames();
        for (String src : allTypes) {
            for (String tgt : allTypes) {
                boolean isImplicit = DataTypeManager.isImplicitConversion((String)src, (String)tgt);
                boolean isExplicit = DataTypeManager.isExplicitConversion((String)src, (String)tgt);
                if (!isImplicit || !isExplicit) continue;
                Assert.fail((String)("Can't be both implicit and explicit for " + src + " to " + tgt));
            }
        }
    }

    @Test
    public void testTimeConversions() {
        Transform t = DataTypeManager.getTransform((String)"timestamp", (String)"date");
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.DATE, (Object)t.getTargetType());
        t = DataTypeManager.getTransform((String)"time", (String)"timestamp");
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.TIMESTAMP, (Object)t.getTargetType());
    }

    @Test
    public void testJDBCSQLTypeInfo() {
        Set types = JDBCSQLTypeInfo.getMMTypeNames();
        for (String type : types) {
            Assert.assertEquals((String)("Didn't get match for " + type), (long)JDBCSQLTypeInfo.getSQLType((String)type), (long)JDBCSQLTypeInfo.getSQLTypeFromRuntimeType((Class)DataTypeManager.getDataTypeClass((String)type)));
            if (type.equalsIgnoreCase("null") || type.equalsIgnoreCase("varbinary") || type.equalsIgnoreCase("xml") || type.equalsIgnoreCase("clob") || type.equalsIgnoreCase("blob") || type.equalsIgnoreCase("json")) continue;
            Assert.assertEquals((String)("Didn't get match for " + type), (long)JDBCSQLTypeInfo.getSQLType((String)type), (long)JDBCSQLTypeInfo.getSQLTypeFromClass((String)DataTypeManager.getDataTypeClass((String)type).getName()));
        }
        Assert.assertEquals((long)93L, (long)JDBCSQLTypeInfo.getSQLTypeFromRuntimeType((Class)DataTypeManager.DefaultDataClasses.TIMESTAMP));
        Assert.assertEquals((long)2009L, (long)JDBCSQLTypeInfo.getSQLTypeFromRuntimeType((Class)DataTypeManager.DefaultDataClasses.XML));
        Assert.assertEquals((Object)"string", (Object)JDBCSQLTypeInfo.getTypeName((int)1));
        Assert.assertEquals((long)1L, (long)JDBCSQLTypeInfo.getSQLTypeFromRuntimeType((Class)DataTypeManager.DefaultDataClasses.CHAR));
        Assert.assertEquals((long)2003L, (long)JDBCSQLTypeInfo.getSQLType((String)DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.BIG_DECIMAL))));
    }

    @Test
    public void testRuntimeTypeConversion() throws Exception {
        Assert.assertNull((Object)DataTypeManager.convertToRuntimeType(null, (boolean)true));
        Assert.assertTrue((boolean)(DataTypeManager.convertToRuntimeType((Object)new SerialBlob(new byte[0]), (boolean)true) instanceof BlobType));
        Object foo = new Object();
        Assert.assertEquals((Object)foo, (Object)DataTypeManager.convertToRuntimeType((Object)foo, (boolean)true));
        Integer bar = new Integer(1);
        Assert.assertEquals((Object)bar, (Object)DataTypeManager.convertToRuntimeType((Object)bar, (boolean)true));
    }

    @Test
    public void testObjectType() {
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.OBJECT, (Object)DataTypeManager.getDataTypeClass((String)"foo"));
        Assert.assertEquals((Object)"object", (Object)DataTypeManager.getDataTypeName(TestDataTypeManager.class));
    }

    @Test
    public void testImplicitConversions() {
        ArrayList c = new ArrayList();
        DataTypeManager.getImplicitConversions((String)"integer", c);
        Assert.assertEquals(Arrays.asList("long", "biginteger", "double", "bigdecimal", "string", "object"), c);
    }

    @Test(expected=TransformationException.class)
    public void testStringToXML() throws Exception {
        DataTypeManager.transformValue((Object)"hello", (Class)DataTypeManager.DefaultDataClasses.XML);
    }

    @Test
    public void testObjectToString() throws Exception {
        Assert.assertEquals((Object)"hello", (Object)DataTypeManager.transformValue((Object)new Foo(), (Class)DataTypeManager.DefaultDataClasses.STRING));
    }

    @Test
    public void testObjectArrayToObject() throws Exception {
        Object[] value = new Object[]{1, 2};
        Assert.assertArrayEquals((Object[])value, (Object[])((Object[])DataTypeManager.transformValue((Object)value, value.getClass(), (Class)DataTypeManager.DefaultDataClasses.OBJECT)));
    }

    @Test
    public void testByteArray() throws Exception {
        byte[] value = new byte[]{1, 2};
        Assert.assertArrayEquals((byte[])value, (byte[])((byte[])DataTypeManager.convertToRuntimeType((Object)value, (boolean)false)));
        Assert.assertEquals((Object)new BinaryType(value), (Object)DataTypeManager.convertToRuntimeType((Object)value, (boolean)true));
    }

    @Test
    public void testObjectTypeArray() throws Exception {
        Object[] value = new Object[]{"a", "b"};
        DataTypeManager.transformValue((Object)value, value.getClass(), String[].class);
    }

    @Test
    public void isHashable() {
        Assert.assertFalse((boolean)DataTypeManager.isHashable((Class)DataTypeManager.DefaultDataClasses.STRING, (boolean)true, null));
        Assert.assertFalse((boolean)DataTypeManager.isHashable(String[].class, (boolean)false, (String)"Something"));
    }

    @Test
    public void testGeographyToGeometry() throws Exception {
        Assert.assertTrue((boolean)(DataTypeManager.transformValue((Object)new GeographyType(new byte[0]), (Class)DataTypeManager.DefaultDataClasses.GEOMETRY) instanceof GeometryType));
    }

    static class Foo {
        Foo() {
        }

        public String toString() {
            return "hello";
        }
    }
}

