/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;

public abstract class Transform {
    public Object transform(Object value, Class<?> targetType) throws TransformationException {
        if (value == null) {
            return null;
        }
        return this.transformDirect(value);
    }

    protected abstract Object transformDirect(Object var1) throws TransformationException;

    public abstract Class<?> getSourceType();

    public String getSourceTypeName() {
        return DataTypeManager.getDataTypeName(this.getSourceType());
    }

    public abstract Class<?> getTargetType();

    public String getTargetTypeName() {
        return DataTypeManager.getDataTypeName(this.getTargetType());
    }

    public String getDisplayName() {
        return this.getSourceTypeName() + " to " + this.getTargetTypeName();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public boolean isExplicit() {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

