/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.sql.Blob;
import org.teiid.core.types.BlobType;

public abstract class AbstractGeospatialType
extends BlobType {
    private int srid;
    private Reference<?> geoCache;

    public AbstractGeospatialType() {
    }

    public AbstractGeospatialType(Blob blob) {
        super(blob);
    }

    public AbstractGeospatialType(byte[] bytes) {
        super(bytes);
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int srid) {
        this.srid = srid;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.srid);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.srid = in.readInt();
    }

    public synchronized Object getGeoCache() {
        if (this.geoCache == null) {
            return null;
        }
        Object result = this.geoCache.get();
        if (result != null && this.geoCache instanceof WeakReference) {
            this.geoCache = new SoftReference(result);
        }
        return result;
    }

    public synchronized void setGeoCache(Object objectReference) {
        this.geoCache = objectReference == null ? null : new WeakReference<Object>(objectReference);
    }

    public synchronized void copyTo(AbstractGeospatialType geo) {
        geo.setGeoCache(this.geoCache == null ? null : this.geoCache.get());
        geo.setSrid(this.srid);
        geo.setReference((Blob)this.reference);
    }
}

