/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;

public class TestMetaMatrixException {
    @Test
    public void testMetaMatrixExceptionWithNullThrowable() {
        TeiidException err = new TeiidException((Throwable)null);
        Assert.assertNull((Object)err.getCode());
        Assert.assertNull((Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixExceptionWithMessage() {
        TeiidException err = new TeiidException("Test");
        Assert.assertNull((Object)err.getCode());
        Assert.assertEquals((Object)"Test", (Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixExceptionWithCodeAndMessage() {
        TeiidException err = new TeiidException((BundleUtil.Event)Event.Code, "Test");
        Assert.assertEquals((Object)"Code", (Object)err.getCode());
        Assert.assertEquals((Object)"Code Test", (Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixExceptionWithExceptionAndMessage() {
        TeiidException child = new TeiidException((BundleUtil.Event)Event.propertyValuePhrase, "Child");
        TeiidException err = new TeiidException((Throwable)child, "Test");
        Assert.assertEquals((Object)"propertyValuePhrase", (Object)err.getCode());
        Assert.assertEquals((Object)"propertyValuePhrase Test", (Object)err.getMessage());
    }

    @Test
    public void testMetaMatrixExceptionWithExceptionAndCodeAndMessage() {
        TeiidException child = new TeiidException((BundleUtil.Event)Event.propertyValuePhrase, "Child");
        TeiidException err = new TeiidException((BundleUtil.Event)Event.Code, (Throwable)child, "Test");
        Assert.assertEquals((Object)"Code", (Object)err.getCode());
        Assert.assertEquals((Object)"Code Test", (Object)err.getMessage());
    }

    public static enum Event implements BundleUtil.Event
    {
        Code,
        propertyValuePhrase;

    }
}

