/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.MultiArrayOutputStream;

public class TestMultiArrayOutputStream {
    @Test
    public void testArrayWrites() throws IOException {
        MultiArrayOutputStream maos = new MultiArrayOutputStream(2);
        for (int i = 0; i < 10; ++i) {
            int len = 1 << i;
            maos.write(new byte[len], 0, len);
        }
        Assert.assertEquals((long)1023L, (long)maos.getCount());
        Assert.assertEquals((long)1L, (long)maos.getIndex());
    }

    @Test
    public void testCount() throws IOException {
        int i;
        MultiArrayOutputStream maos = new MultiArrayOutputStream(2);
        for (i = 0; i < 4; ++i) {
            maos.write(i);
        }
        Assert.assertEquals((long)4L, (long)maos.getCount());
        Assert.assertEquals((long)2L, (long)maos.getIndex());
        maos = new MultiArrayOutputStream(2);
        for (i = 0; i < 4; ++i) {
            int len = 3;
            maos.write(new byte[len]);
        }
        Assert.assertEquals((long)12L, (long)maos.getCount());
        Assert.assertEquals((long)6L, (long)maos.getIndex());
    }
}

