/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.ObjectConverterUtil;

public class TestObjectConverterUtil {
    @Test
    public void testWriteWithLength() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        ObjectConverterUtil.write((OutputStream)baos, (InputStream)bais, (byte[])new byte[3], (int)4);
        Assert.assertEquals((long)4L, (long)baos.toByteArray().length);
        StringWriter sw = new StringWriter();
        StringReader sr = new StringReader("123");
        ObjectConverterUtil.write((Writer)sw, (Reader)sr, (int)2, (boolean)true);
        Assert.assertEquals((long)2L, (long)sw.toString().length());
    }

    @Test
    public void testCloseArguments() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                throw new AssertionError();
            }
        };
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        ObjectConverterUtil.write((OutputStream)baos, (InputStream)bais, (byte[])new byte[3], (int)4, (boolean)false, (boolean)true);
        Assert.assertEquals((long)4L, (long)baos.toByteArray().length);
    }
}

