/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.core.util.TimestampWithTimezone;

public class TestTimestampWithTimezone {
    @Before
    public void setUp() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("America/Chicago"));
    }

    @After
    public void tearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }

    public void helpTestSame(String startts, int startnanos, String starttz, String endtz) {
        try {
            Timestamp start = this.getTimestamp(startts, startnanos, starttz);
            Timestamp end = this.getTimestamp(startts, startnanos, endtz);
            Assert.assertFalse((String)"Initial timestamps should be different UTC times", (start.getTime() == end.getTime() ? 1 : 0) != 0);
            Assert.assertEquals((long)TimestampWithTimezone.createTimestamp((Date)start, (TimeZone)TimeZone.getTimeZone(starttz), (Calendar)Calendar.getInstance()).getTime(), (long)TimestampWithTimezone.createTimestamp((Date)end, (TimeZone)TimeZone.getTimeZone(endtz), (Calendar)Calendar.getInstance()).getTime());
        }
        catch (ParseException e) {
            Assert.fail((String)e.toString());
        }
    }

    public void helpTestChange(String ts, String endtz, String expected) {
        Timestamp start = Timestamp.valueOf(ts);
        Calendar target = Calendar.getInstance(TimeZone.getTimeZone(endtz));
        Assert.assertEquals((Object)expected, (Object)TimestampWithTimezone.createTimestamp((Date)start, (TimeZone)TimeZone.getTimeZone("America/Chicago"), (Calendar)target).toString());
    }

    private Timestamp getTimestamp(String startts, int startnanos, String starttz) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone(starttz));
        Timestamp ts = new Timestamp(df.parse(startts).getTime());
        ts.setNanos(startnanos);
        return ts;
    }

    @Test
    public void testDST() {
        this.helpTestSame("2005-10-30 02:39:10", 1, "America/Chicago", "GMT-05:00");
        this.helpTestSame("2005-10-30 01:39:10", 1, "America/Chicago", "GMT");
        this.helpTestSame("2005-04-03 02:39:10", 1, "GMT", "America/Chicago");
        this.helpTestChange("2005-10-30 02:39:10.1", "GMT", "2005-10-29 21:39:10.1");
        this.helpTestChange("2005-10-30 10:39:10.1", "GMT", "2005-10-30 04:39:10.1");
    }

    @Test
    public void testTimezone() {
        this.helpTestSame("2004-06-29 15:39:10", 1, "GMT-06:00", "GMT-05:00");
    }

    @Test
    public void testTimezone2() {
        this.helpTestSame("2004-06-29 15:39:10", 1, "GMT-08:00", "GMT-06:00");
    }

    @Test
    public void testTimezone3() {
        this.helpTestSame("2004-08-31 18:25:54", 1, "Europe/London", "GMT");
    }

    @Test
    public void testTimezoneOverMidnight() {
        this.helpTestSame("2004-06-30 23:39:10", 1, "America/Los_Angeles", "America/Chicago");
    }

    @Test
    public void testCase2852() {
        this.helpTestSame("2005-05-17 22:35:33", 508659, "GMT", "America/New_York");
    }

    @Test
    public void testCreateDate() {
        Timestamp t = Timestamp.valueOf("2004-06-30 23:39:10.1201");
        java.sql.Date date = TimestampWithTimezone.createDate((Date)t);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        Assert.assertEquals((long)cal.get(11), (long)0L);
        Assert.assertEquals((long)cal.get(12), (long)0L);
        Assert.assertEquals((long)cal.get(13), (long)0L);
        Assert.assertEquals((long)cal.get(14), (long)0L);
        Assert.assertEquals((long)cal.get(1), (long)2004L);
        Assert.assertEquals((long)cal.get(2), (long)5L);
        Assert.assertEquals((long)cal.get(5), (long)30L);
    }

    @Test
    public void testCreateTime() {
        Timestamp t = Timestamp.valueOf("2004-06-30 23:39:10.1201");
        Time date = TimestampWithTimezone.createTime((Date)t);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        Assert.assertEquals((long)cal.get(11), (long)23L);
        Assert.assertEquals((long)cal.get(12), (long)39L);
        Assert.assertEquals((long)cal.get(13), (long)10L);
        Assert.assertEquals((long)cal.get(14), (long)0L);
        Assert.assertEquals((long)cal.get(1), (long)1970L);
        Assert.assertEquals((long)cal.get(2), (long)0L);
        Assert.assertEquals((long)cal.get(5), (long)1L);
    }

    @Test
    public void testDateToDateConversion() {
        java.sql.Date t = java.sql.Date.valueOf("2004-06-30");
        java.sql.Date converted = TimestampWithTimezone.createDate((Date)t, (TimeZone)TimeZone.getTimeZone("America/Chicago"), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("US/Central")));
        Assert.assertEquals((long)t.getTime(), (long)converted.getTime());
    }

    @Test
    public void testDateToDateConversion1() {
        java.sql.Date t = java.sql.Date.valueOf("2004-06-30");
        java.sql.Date converted = TimestampWithTimezone.createDate((Date)t, (TimeZone)TimeZone.getTimeZone("America/Chicago"), (Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        Calendar cal = Calendar.getInstance();
        cal.setTime(converted);
        Assert.assertEquals((long)0L, (long)cal.get(14));
    }
}

