/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.eclipselink.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.resource.ResourceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.resource.adapter.file.FileManagedConnectionFactory;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.file.FileExecutionFactory;

public class TestTeiidPlatform {
    static EmbeddedServer server;
    static EntityManagerFactory factory;

    @BeforeClass
    public static void init() throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, FileNotFoundException, IOException, ResourceException, SQLException {
        server = new EmbeddedServer();
        FileExecutionFactory executionFactory = new FileExecutionFactory();
        server.addTranslator("file", (ExecutionFactory)executionFactory);
        FileManagedConnectionFactory fileManagedconnectionFactory = new FileManagedConnectionFactory();
        fileManagedconnectionFactory.setParentDirectory(UnitTestUtil.getTestDataPath() + File.separator + "file");
        BasicConnectionFactory connectionFactory = fileManagedconnectionFactory.createConnectionFactory();
        EmbeddedServer.SimpleConnectionFactoryProvider connectionFactoryProvider = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)connectionFactory);
        server.addConnectionFactoryProvider("java:/marketdata-file", (EmbeddedServer.ConnectionFactoryProvider)connectionFactoryProvider);
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        server.start(config);
        DriverManager.registerDriver((Driver)server.getDriver());
        server.deployVDB((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)("vdb" + File.separator + "marketdata-vdb.xml"))));
        factory = Persistence.createEntityManagerFactory((String)"org.teiid.eclipselink.test");
    }

    @Test
    public void testInit() throws Exception {
        Assert.assertNotNull((Object)factory);
        EntityManager em = factory.createEntityManager();
        Assert.assertNotNull((Object)em);
        em.close();
    }

    @Test
    public void testJPQLQuery() {
        EntityManager em = factory.createEntityManager();
        List list = em.createQuery("SELECT m FROM Marketdata m").getResultList();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)10L, (long)list.size());
        em.close();
    }

    @AfterClass
    public static void destory() {
        factory.close();
        try {
            DriverManager.deregisterDriver((Driver)server.getDriver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        server.stop();
    }
}

