/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.eclipselink.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.file.JavaVirtualFile;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.file.FileExecutionFactory;

public class TestTeiidPlatform {
    static EmbeddedServer server;
    static EntityManagerFactory factory;

    @BeforeClass
    public static void init() throws Exception {
        server = new EmbeddedServer();
        FileExecutionFactory executionFactory = new FileExecutionFactory();
        server.addTranslator("file", (ExecutionFactory)executionFactory);
        server.addConnectionFactory("java:/marketdata-file", (Object)new ConnectionFactory<VirtualFileConnection>(){

            public VirtualFileConnection getConnection() throws Exception {
                VirtualFileConnection result = (VirtualFileConnection)Mockito.mock(VirtualFileConnection.class);
                JavaVirtualFile javaVirtualFile = new JavaVirtualFile(UnitTestUtil.getTestDataFile((String)"file/marketdata.csv"));
                Mockito.stub((Object)result.getFiles(Mockito.anyString())).toReturn((Object)new VirtualFile[]{javaVirtualFile});
                return result;
            }
        });
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        server.start(config);
        DriverManager.registerDriver((Driver)server.getDriver());
        server.deployVDB((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)("vdb" + File.separator + "marketdata-vdb.xml"))));
        factory = Persistence.createEntityManagerFactory((String)"org.teiid.eclipselink.test");
    }

    @Test
    public void testInit() throws Exception {
        Assert.assertNotNull((Object)factory);
        EntityManager em = factory.createEntityManager();
        Assert.assertNotNull((Object)em);
        em.close();
    }

    @Test
    public void testJPQLQuery() {
        EntityManager em = factory.createEntityManager();
        List list = em.createQuery("SELECT m FROM Marketdata m").getResultList();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)10L, (long)list.size());
        em.close();
    }

    @AfterClass
    public static void destory() {
        factory.close();
        try {
            DriverManager.deregisterDriver((Driver)server.getDriver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        server.stop();
    }
}

