/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.jboss.TestVDBMetaData;
import org.teiid.adminapi.jboss.VDBMetadataMapper;

public class TestSessionMetadata {
    private static final String describe = "{\"attributes\" : {\n    \"application-name\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"application-name\",\n        \"expressions-allowed\" : false,\n        \"required\" : false,\n        \"nillable\" : true,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"created-time\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"LONG\"\n        },\n        \"description\" : \"created-time\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false\n    },\n    \"client-host-address\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"client-host-address\",\n        \"expressions-allowed\" : false,\n        \"required\" : false,\n        \"nillable\" : true,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"client-hardware-address\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"client-hardware-address\",\n        \"expressions-allowed\" : false,\n        \"required\" : false,\n        \"nillable\" : true,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"ip-address\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"ip-address\",\n        \"expressions-allowed\" : false,\n        \"required\" : false,\n        \"nillable\" : true,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"last-ping-time\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"LONG\"\n        },\n        \"description\" : \"last-ping-time\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false\n    },\n    \"session-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"session-id\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"user-name\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"user-name\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"vdb-name\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"vdb-name\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"vdb-version\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"vdb-version\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"security-domain\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"security-domain\",\n        \"expressions-allowed\" : false,\n        \"required\" : false,\n        \"nillable\" : true,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    }\n}}";

    @Test
    public void testMapping() {
        SessionMetadata session = new SessionMetadata();
        session.setSessionId("test");
        session.setApplicationName("foo");
        session.setClientHostName("localhost");
        session.setCreatedTime(1234L);
        session.setIPAddress("127.0.0.1");
        session.setVDBName("vdb-name");
        session.setVDBVersion((Object)2);
        session.setSecurityContext((Object)"auth-domain");
        session.setUserName("user");
        ModelNode node = VDBMetadataMapper.SessionMetadataMapper.INSTANCE.wrap(session, new ModelNode());
        SessionMetadata session1 = VDBMetadataMapper.SessionMetadataMapper.INSTANCE.unwrap(node);
        Assert.assertEquals((Object)session.getSessionId(), (Object)session1.getSessionId());
        Assert.assertEquals((Object)session.getApplicationName(), (Object)session1.getApplicationName());
    }

    @Test
    public void testDescribe() {
        ModelNode n = TestVDBMetaData.describe(new ModelNode(), VDBMetadataMapper.SessionMetadataMapper.INSTANCE.getAttributeDefinitions());
        Assert.assertEquals((Object)describe, (Object)n.toJSONString(false));
    }
}

