/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.jboss.TestVDBMetaData;
import org.teiid.adminapi.jboss.VDBMetadataMapper;

public class TestRequestMetadata {
    public static final String desc = "{\"attributes\" : {\n    \"execution-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"LONG\"\n        },\n        \"description\" : \"execution-id\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false\n    },\n    \"session-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"session-id\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"start-time\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"LONG\"\n        },\n        \"description\" : \"start-time\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false\n    },\n    \"command\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"command\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"source-request\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"BOOLEAN\"\n        },\n        \"description\" : \"source-request\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false\n    },\n    \"node-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"INT\"\n        },\n        \"description\" : \"node-id\",\n        \"expressions-allowed\" : false,\n        \"required\" : false,\n        \"nillable\" : true\n    },\n    \"transaction-id\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"transaction-id\",\n        \"expressions-allowed\" : false,\n        \"required\" : false,\n        \"nillable\" : true,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"processing-state\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"processing-state\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    },\n    \"thread-state\" : {\n        \"type\" : {\n            \"TYPE_MODEL_VALUE\" : \"STRING\"\n        },\n        \"description\" : \"thread-state\",\n        \"expressions-allowed\" : false,\n        \"required\" : true,\n        \"nillable\" : false,\n        \"min-length\" : 1,\n        \"max-length\" : 2147483647\n    }\n}}";

    @Test
    public void testMapping() {
        RequestMetadata request = this.buildRequest();
        ModelNode node = VDBMetadataMapper.RequestMetadataMapper.INSTANCE.wrap(request, new ModelNode());
        RequestMetadata actual = VDBMetadataMapper.RequestMetadataMapper.INSTANCE.unwrap(node);
        Assert.assertEquals((Object)request, (Object)actual);
        Assert.assertEquals((Object)request.getState(), (Object)actual.getState());
    }

    private RequestMetadata buildRequest() {
        RequestMetadata request = new RequestMetadata();
        request.setState(Request.ProcessingState.PROCESSING);
        request.setCommand("select * from foo");
        request.setExecutionId(1234L);
        request.setName("request-name");
        request.setSessionId("session-id");
        request.setSourceRequest(false);
        request.setStartTime(12345L);
        request.setTransactionId("transaction-id");
        request.setThreadState(Request.ThreadState.RUNNING);
        return request;
    }

    @Test
    public void testDescribe() {
        Assert.assertEquals((Object)desc, (Object)TestVDBMetaData.describe(new ModelNode(), VDBMetadataMapper.RequestMetadataMapper.INSTANCE.getAttributeDefinitions()).toJSONString(false));
    }
}

