/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.TestVDBUtility;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.adminapi.jboss.VDBMetadataMapper;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.UnitTestUtil;

public class TestVDBMetaData {
    @Test
    public void testMarshellUnmarshellDirectParsing() throws Exception {
        VDBMetaData vdb = TestVDBUtility.buildVDB();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        VDBMetadataParser.marshell((VDBMetaData)vdb, (OutputStream)out);
        vdb = VDBMetadataParser.unmarshell((InputStream)new ByteArrayInputStream(out.toByteArray()));
        TestVDBUtility.validateVDB((VDBMetaData)vdb);
    }

    @Test
    public void testAdminMOCreation() {
        VDBMetaData vdb = new VDBMetaData();
        PropertiesUtils.setBeanProperty((Object)vdb, (String)"name", (Object)"x");
        Assert.assertEquals((Object)"x", (Object)vdb.getName());
    }

    @Test
    public void testVDBMetaDataMapper() {
        VDBMetaData vdb = TestVDBUtility.buildVDB();
        ModelNode node = VDBMetadataMapper.INSTANCE.wrap(vdb, new ModelNode());
        vdb = VDBMetadataMapper.INSTANCE.unwrap(node);
        TestVDBUtility.validateVDB((VDBMetaData)vdb);
    }

    @Test
    public void testVDBMetaDataDescribe() throws Exception {
        ModelNode node = TestVDBMetaData.describe(new ModelNode(), VDBMetadataMapper.INSTANCE.getAttributeDefinitions());
        String actual = node.toJSONString(false);
        Assert.assertEquals((Object)ObjectConverterUtil.convertFileToString((File)new File(UnitTestUtil.getTestDataPath() + "/vdb-describe.txt")), (Object)actual);
    }

    @Test
    public void testClone() {
        VDBMetaData vdb = TestVDBUtility.buildVDB();
        vdb.setXmlDeployment(true);
        VDBMetaData clone = vdb.clone();
        Assert.assertTrue((boolean)clone.isXmlDeployment());
        Assert.assertEquals((long)1L, (long)vdb.getVDBImports().size());
        Assert.assertNotSame((Object)clone.getModelMetaDatas(), (Object)vdb.getModelMetaDatas());
    }

    public static ModelNode describe(ModelNode node, AttributeDefinition[] attributes) {
        for (AttributeDefinition ad : attributes) {
            ad.addResourceAttributeDescription(node, (ResourceDescriptionResolver)NonResolvingResourceDescriptionResolver.INSTANCE, null, NonResolvingResourceDescriptionResolver.INSTANCE.getResourceBundle(null));
        }
        return node;
    }
}

