/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.VDBOperations;

class AddSource
extends VDBOperations {
    public AddSource() {
        super("add-source", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeOperation(OperationContext context, RuntimeVDB vdb, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.MODEL_NAME.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.MODEL_NAME.getName() + ".missing"));
        }
        if (!operation.hasDefined(OperationsConstants.SOURCE_NAME.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.SOURCE_NAME.getName() + ".missing"));
        }
        if (!operation.hasDefined(OperationsConstants.TRANSLATOR_NAME.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.TRANSLATOR_NAME.getName() + ".missing"));
        }
        if (!operation.hasDefined(OperationsConstants.DS_NAME.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.DS_NAME.getName() + ".missing"));
        }
        String modelName = operation.get(OperationsConstants.MODEL_NAME.getName()).asString();
        String sourceName = operation.get(OperationsConstants.SOURCE_NAME.getName()).asString();
        String translatorName = operation.get(OperationsConstants.TRANSLATOR_NAME.getName()).asString();
        String dsName = operation.get(OperationsConstants.DS_NAME.getName()).asString();
        try {
            VDBMetaData vDBMetaData = vdb.getVdb();
            synchronized (vDBMetaData) {
                RuntimeVDB.ReplaceResult rr = vdb.addSource(modelName, sourceName, translatorName, dsName);
                AddSource.updateServices(context, vdb, dsName, rr);
            }
        }
        catch (AdminProcessingException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        super.describeParameters(builder);
        builder.addParameter((AttributeDefinition)OperationsConstants.MODEL_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.SOURCE_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.TRANSLATOR_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.DS_NAME);
    }
}

