/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.Closeable;
import java.io.IOException;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.MountType;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class FileRootMountProcessor
implements DeploymentUnitProcessor {
    private String fileSuffix;

    public FileRootMountProcessor(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        MountHandle mountHandle;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT) != null || !deploymentUnit.getName().toLowerCase().endsWith(this.fileSuffix)) {
            return;
        }
        DeploymentMountProvider deploymentMountProvider = (DeploymentMountProvider)deploymentUnit.getAttachment(Attachments.SERVER_DEPLOYMENT_REPOSITORY);
        if (deploymentMountProvider == null) {
            throw new DeploymentUnitProcessingException("No deployment repository available.");
        }
        VirtualFile deploymentContents = (VirtualFile)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_CONTENTS);
        if (deploymentContents == null) {
            return;
        }
        String deploymentName = deploymentUnit.getName();
        VirtualFile deploymentRoot = VFS.getChild((String)("content/" + deploymentName));
        Closeable handle = null;
        boolean failed = false;
        try {
            handle = deploymentMountProvider.mountDeploymentContent(deploymentContents, deploymentRoot, MountType.REAL);
            mountHandle = new MountHandle(handle);
        }
        catch (IOException e) {
            failed = true;
            throw new DeploymentUnitProcessingException("Failed to mount " + this.fileSuffix + " file", (Throwable)e);
        }
        finally {
            if (failed) {
                VFSUtils.safeClose((Closeable)handle);
            }
        }
        ResourceRoot resourceRoot = new ResourceRoot(deploymentRoot, mountHandle);
        ModuleRootMarker.mark((ResourceRoot)resourceRoot);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_ROOT, (Object)resourceRoot);
        deploymentUnit.putAttachment(Attachments.MODULE_SPECIFICATION, (Object)new ModuleSpecification());
    }

    public void undeploy(DeploymentUnit context) {
        ResourceRoot knobRoot = (ResourceRoot)context.removeAttachment(Attachments.DEPLOYMENT_ROOT);
        if (knobRoot != null) {
            MountHandle mountHandle = knobRoot.getMountHandle();
            VFSUtils.safeClose((Closeable)mountHandle);
        }
    }
}

