/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.client.plan.PlanNode;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;

class GetPlan
extends TeiidOperationHandler {
    protected GetPlan() {
        super("get-query-plan");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.SESSION.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.SESSION.getName() + ".missing"));
        }
        if (!operation.hasDefined(OperationsConstants.EXECUTION_ID.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.EXECUTION_ID.getName() + ".missing"));
        }
        PlanNode plan = engine.getPlan(operation.get(OperationsConstants.SESSION.getName()).asString(), operation.get(OperationsConstants.EXECUTION_ID.getName()).asLong());
        ModelNode result = context.getResult();
        if (plan != null) {
            result.set(plan.toXml());
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.SESSION);
        builder.addParameter((AttributeDefinition)OperationsConstants.EXECUTION_ID);
        builder.setReplyType(ModelType.STRING);
    }
}

