/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.jboss.VDBMetadataMapper;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidServiceNames;

class GetVDB
extends BaseOperationHandler<VDBRepository> {
    protected GetVDB() {
        super("get-vdb");
    }

    @Override
    protected VDBRepository getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        return (VDBRepository)VDBRepository.class.cast(sc.getValue());
    }

    @Override
    protected void executeOperation(OperationContext context, VDBRepository repo, ModelNode operation) throws OperationFailedException {
        String vdbVersion;
        if (!operation.hasDefined(OperationsConstants.VDB_NAME.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.VDB_NAME.getName() + ".missing"));
        }
        if (!operation.hasDefined(OperationsConstants.VDB_VERSION.getName())) {
            throw new OperationFailedException(IntegrationPlugin.Util.getString(OperationsConstants.VDB_VERSION.getName() + ".missing"));
        }
        boolean includeSchema = true;
        if (operation.hasDefined(OperationsConstants.INCLUDE_SCHEMA.getName())) {
            includeSchema = operation.get(OperationsConstants.INCLUDE_SCHEMA.getName()).asBoolean();
        }
        ModelNode result = context.getResult();
        String vdbName = operation.get(OperationsConstants.VDB_NAME.getName()).asString();
        VDBMetaData vdb = repo.getVDB(vdbName, (Object)(vdbVersion = operation.get(OperationsConstants.VDB_VERSION.getName()).asString()));
        if (vdb != null) {
            VDBMetadataMapper.INSTANCE.wrap(vdb, result, includeSchema);
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_VERSION);
        builder.addParameter((AttributeDefinition)OperationsConstants.INCLUDE_SCHEMA);
        builder.setReplyType(ModelType.OBJECT);
        builder.setReplyParameters(VDBMetadataMapper.INSTANCE.getAttributeDefinitions());
    }
}

