/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.translator.BaseDelegatingExecutionFactory;
import org.teiid.translator.ExecutionFactory;

public class TestVDBService {
    @Test(expected=ConnectorManagerRepository.ConnectorManagerException.class)
    public void testMissingDelegate() throws ConnectorManagerRepository.ConnectorManagerException {
        TranslatorRepository repo = new TranslatorRepository();
        VDBTranslatorMetaData tmd = new VDBTranslatorMetaData();
        Properties props = new Properties();
        props.put("delegateName", "y");
        tmd.setProperties(props);
        tmd.setExecutionFactoryClass(SampleExecutionFactory.class);
        repo.addTranslatorMetadata("x", tmd);
        TranslatorUtil.getExecutionFactory((String)"x", (TranslatorRepository)repo, (TranslatorRepository)repo, (VDBMetaData)new VDBMetaData(), new IdentityHashMap(), new HashSet());
    }

    @Test
    public void testAddSupportedFunctions() throws ConnectorManagerRepository.ConnectorManagerException {
        TranslatorRepository repo = new TranslatorRepository();
        VDBTranslatorMetaData tmd = new VDBTranslatorMetaData();
        Properties props = new Properties();
        props.put("delegateName", "y");
        props.put("addSupportedFunctions", "a,b,c");
        tmd.setProperties(props);
        tmd.setExecutionFactoryClass(SampleExecutionFactory.class);
        repo.addTranslatorMetadata("x", tmd);
        VDBTranslatorMetaData tmd1 = new VDBTranslatorMetaData();
        repo.addTranslatorMetadata("y", tmd1);
        IdentityHashMap<VDBTranslatorMetaData, ExecutionFactory> map = new IdentityHashMap<VDBTranslatorMetaData, ExecutionFactory>();
        map.put(tmd1, new ExecutionFactory());
        ExecutionFactory ef = TranslatorUtil.getExecutionFactory((String)"x", (TranslatorRepository)repo, (TranslatorRepository)repo, (VDBMetaData)new VDBMetaData(), map, new HashSet());
        Assert.assertEquals((long)3L, (long)ef.getSupportedFunctions().size());
    }

    public static class SampleExecutionFactory
    extends BaseDelegatingExecutionFactory<Void, Void> {
    }
}

