/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import org.jboss.as.controller.ModelController;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.RestWarGenerator;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.logging.LogManager;

public class ResteasyEnabler
implements VDBLifeCycleListener,
Service<Void> {
    protected final InjectedValue<ModelController> controllerValue = new InjectedValue();
    protected final InjectedValue<Executor> executorInjector = new InjectedValue();
    final InjectedValue<VDBRepository> vdbRepoInjector = new InjectedValue();
    private final RestWarGenerator generator;

    public ResteasyEnabler(RestWarGenerator generator) {
        this.generator = generator;
    }

    public void added(String name, CompositeVDB vdb) {
    }

    public void beforeRemove(String name, CompositeVDB cvdb) {
        if (cvdb != null) {
            // empty if block
        }
    }

    public void finishedDeployment(String name, CompositeVDB cvdb) {
        final VDBMetaData vdb = cvdb.getVDB();
        if (!vdb.getStatus().equals((Object)VDB.Status.ACTIVE)) {
            return;
        }
        final String warName = this.buildName(name, cvdb.getVDB().getVersion());
        if (this.generator.hasRestMetadata(vdb)) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    try {
                        byte[] warContents = ResteasyEnabler.this.generator.getContent(vdb);
                        if (!vdb.getStatus().equals((Object)VDB.Status.ACTIVE)) {
                            return;
                        }
                        if (warContents != null) {
                            ResteasyEnabler.this.getAdmin().deploy(warName, (InputStream)new ByteArrayInputStream(warContents), false);
                        }
                    }
                    catch (IOException e) {
                        LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50109, new Object[]{warName}));
                    }
                    catch (AdminException e) {
                        LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50109, new Object[]{warName}));
                    }
                }
            };
            this.getExecutor().execute(job);
        }
    }

    public void removed(String name, CompositeVDB cvdb) {
    }

    private String buildName(String name, String version) {
        return name + "_" + version + ".war";
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public void start(StartContext arg0) throws StartException {
        ((VDBRepository)this.vdbRepoInjector.getValue()).addListener((VDBLifeCycleListener)this);
    }

    public void stop(StopContext arg0) {
    }

    Admin getAdmin() {
        return AdminFactory.getInstance().createAdmin(((ModelController)this.controllerValue.getValue()).createClient((Executor)this.executorInjector.getValue()));
    }

    Executor getExecutor() {
        return (Executor)this.executorInjector.getValue();
    }
}

