/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.ContainerLifeCycleListener;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.ObjectSerializer;
import org.teiid.jboss.TeiidAdd;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.index.IndexMetadataRepository;
import org.teiid.query.metadata.VDBResources;
import org.teiid.runtime.AbstractVDBDeployer;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.vdb.runtime.VDBKey;

class VDBService
extends AbstractVDBDeployer
implements Service<RuntimeVDB> {
    private VDBMetaData vdb;
    private RuntimeVDB runtimeVDB;
    protected final InjectedValue<VDBRepository> vdbRepositoryInjector = new InjectedValue();
    protected final InjectedValue<TranslatorRepository> translatorRepositoryInjector = new InjectedValue();
    protected final InjectedValue<Executor> executorInjector = new InjectedValue();
    protected final InjectedValue<ObjectSerializer> serializerInjector = new InjectedValue();
    protected final InjectedValue<VDBStatusChecker> vdbStatusCheckInjector = new InjectedValue();
    private VDBLifeCycleListener vdbListener;
    private VDBResources vdbResources;
    private VDBKey vdbKey;

    public VDBService(VDBMetaData metadata, VDBResources vdbResources, ContainerLifeCycleListener shutdownListener) {
        this.vdb = metadata;
        this.vdbKey = new VDBKey(metadata.getName(), (Object)metadata.getVersion());
        this.vdbResources = vdbResources;
    }

    public void start(StartContext context) throws StartException {
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        TranslatorRepository repo = new TranslatorRepository();
        this.vdb.addAttchment(TranslatorRepository.class, (Object)repo);
        UDFMetaData udf = (UDFMetaData)this.vdb.getAttachment(UDFMetaData.class);
        for (Translator t : this.vdb.getOverrideTranslators()) {
            VDBTranslatorMetaData data = (VDBTranslatorMetaData)t;
            String type = data.getType();
            VDBTranslatorMetaData parent = this.getTranslatorRepository().getTranslatorMetaData(type);
            data.setModuleName(parent.getModuleName());
            data.addAttchment(ClassLoader.class, parent.getAttachment(ClassLoader.class));
            data.setParent(parent);
            repo.addTranslatorMetadata(data.getName(), data);
        }
        this.createConnectorManagers(cmr, repo, this.vdb);
        final ServiceBuilder<Void> vdbService = this.addVDBFinishedService(context);
        this.vdbListener = new VDBLifeCycleListener(){

            public void added(String name, CompositeVDB cvdb) {
            }

            public void beforeRemove(String name, CompositeVDB cvdb) {
            }

            public void removed(String name, CompositeVDB cvdb) {
            }

            public void finishedDeployment(String name, CompositeVDB cvdb) {
                if (!VDBService.this.vdbKey.equals((Object)cvdb.getVDBKey())) {
                    return;
                }
                VDBService.this.repositories.put("index", new IndexMetadataRepository());
                VDBMetaData vdbInstance = cvdb.getVDB();
                if (vdbInstance.getStatus().equals((Object)VDB.Status.ACTIVE)) {
                    vdbService.install();
                }
            }
        };
        this.getVDBRepository().addListener(this.vdbListener);
        MetadataStore store = new MetadataStore();
        try {
            MetadataRepository defaultRepo = null;
            for (String s : this.vdbResources.getEntriesPlusVisibilities().keySet()) {
                if (!s.endsWith(".INDEX")) continue;
                defaultRepo = super.getMetadataRepository("index");
                break;
            }
            this.assignMetadataRepositories(this.vdb, defaultRepo);
            this.getVDBRepository().addVDB(this.vdb, store, this.vdbResources.getEntriesPlusVisibilities(), udf, cmr);
        }
        catch (VirtualDatabaseException e) {
            this.cleanup((LifecycleContext)context);
            throw new StartException((Throwable)e);
        }
        this.vdb.removeAttachment(UDFMetaData.class);
        try {
            this.loadMetadata(this.vdb, cmr, store, this.vdbResources);
        }
        catch (TranslatorException e) {
            this.cleanup((LifecycleContext)context);
            throw new StartException((Throwable)e);
        }
        this.runtimeVDB = this.buildRuntimeVDB(this.vdb, context.getController().getServiceContainer());
    }

    private RuntimeVDB buildRuntimeVDB(final VDBMetaData vdbMetadata, final ServiceContainer serviceContainer) {
        RuntimeVDB.VDBModificationListener modificationListener = new RuntimeVDB.VDBModificationListener(){

            public void dataRoleChanged(String policyName) throws AdminProcessingException {
                VDBService.this.save();
            }

            public void connectionTypeChanged() throws AdminProcessingException {
                VDBService.this.save();
            }

            public void dataSourceChanged(String modelName, String sourceName, String translatorName, String dsName) throws AdminProcessingException {
                VDBService.this.save();
            }

            public void onRestart(List<String> modelNames) {
                ServiceController switchSvc = serviceContainer.getService(TeiidServiceNames.vdbSwitchServiceName(vdbMetadata.getName(), vdbMetadata.getVersion()));
                if (switchSvc != null) {
                    if (!modelNames.isEmpty()) {
                        for (String model : modelNames) {
                            VDBService.this.deleteModelCache(model);
                        }
                    } else {
                        for (String model : vdbMetadata.getModelMetaDatas().keySet()) {
                            VDBService.this.deleteModelCache(model);
                        }
                    }
                    switchSvc.setMode(ServiceController.Mode.REMOVE);
                }
            }
        };
        return new RuntimeVDB(vdbMetadata, modificationListener){

            protected VDBStatusChecker getVDBStatusChecker() {
                return (VDBStatusChecker)VDBService.this.vdbStatusCheckInjector.getValue();
            }
        };
    }

    Service<Void> createVoidService() {
        return new Service<Void>(){

            public Void getValue() throws IllegalStateException, IllegalArgumentException {
                return null;
            }

            public void start(StartContext sc) throws StartException {
            }

            public void stop(StopContext sc) {
            }
        };
    }

    private ServiceBuilder<Void> addVDBFinishedService(StartContext context) {
        ServiceContainer serviceContainer = context.getController().getServiceContainer();
        ServiceController controller = serviceContainer.getService(TeiidServiceNames.vdbFinishedServiceName(this.vdb.getName(), this.vdb.getVersion()));
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        return serviceContainer.addService(TeiidServiceNames.vdbFinishedServiceName(this.vdb.getName(), this.vdb.getVersion()), this.createVoidService());
    }

    void cleanup(LifecycleContext context) {
        this.getVDBRepository().removeVDB(this.vdb.getName(), (Object)this.vdb.getVersion());
        this.getVDBRepository().removeListener(this.vdbListener);
        ServiceController controller = context.getController().getServiceContainer().getService(TeiidServiceNames.vdbFinishedServiceName(this.vdb.getName(), this.vdb.getVersion()));
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50026, new Object[]{this.vdb}));
    }

    public void stop(StopContext context) {
        this.cleanup((LifecycleContext)context);
    }

    public RuntimeVDB getValue() throws IllegalStateException, IllegalArgumentException {
        return this.runtimeVDB;
    }

    private void createConnectorManagers(ConnectorManagerRepository cmr, final TranslatorRepository repo, final VDBMetaData deployment) throws StartException {
        final IdentityHashMap map = new IdentityHashMap();
        try {
            ConnectorManagerRepository.ExecutionFactoryProvider provider = new ConnectorManagerRepository.ExecutionFactoryProvider(){

                public ExecutionFactory<Object, Object> getExecutionFactory(String name) throws ConnectorManagerRepository.ConnectorManagerException {
                    return TranslatorUtil.getExecutionFactory((String)name, (TranslatorRepository)repo, (TranslatorRepository)VDBService.this.getTranslatorRepository(), (VDBMetaData)deployment, (IdentityHashMap)map, new HashSet());
                }
            };
            cmr.setProvider(provider);
            cmr.createConnectorManagers(deployment, provider);
        }
        catch (ConnectorManagerRepository.ConnectorManagerException e) {
            if (e.getCause() != null) {
                throw new StartException(IntegrationPlugin.Event.TEIID50035.name() + " " + e.getMessage(), e.getCause());
            }
            throw new StartException(e.getMessage());
        }
    }

    protected void loadMetadata(final VDBMetaData vdb, final ModelMetaData model, final ConnectorManagerRepository cmr, final MetadataRepository metadataRepo, final MetadataStore vdbMetadataStore, final AtomicInteger loadCount, final VDBResources vdbResources) {
        String msg = IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50029, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), SimpleDateFormat.getInstance().format(new Date())});
        model.setMetadataStatus(Model.MetadataStatus.LOADING);
        model.addRuntimeMessage(ModelMetaData.Message.Severity.INFO, msg);
        LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)msg);
        final Runnable job = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean cached = false;
                Throwable ex = null;
                TranslatorException te = null;
                if (model.getMetadataStatus() != Model.MetadataStatus.LOADING) {
                    model.setMetadataStatus(Model.MetadataStatus.RETRYING);
                }
                NavigableMap datatypes = vdbMetadataStore.getDatatypes();
                File cachedFile = VDBService.this.getSerializer().buildModelFile(vdb, model.getName());
                MetadataFactory factory = VDBService.this.getSerializer().loadSafe(cachedFile, MetadataFactory.class);
                if (factory != null) {
                    factory.correctDatatypes((Map)datatypes);
                    cached = true;
                    LogManager.logDetail((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", vdb.getName(), " was loaded from cached metadata"});
                } else {
                    factory = VDBService.this.createMetadataFactory(vdb, vdbMetadataStore, model, vdbResources.getEntriesPlusVisibilities());
                    ExecutionFactory ef = null;
                    Object cf = null;
                    for (ConnectorManager cm : VDBService.this.getConnectorManagers(model, cmr)) {
                        if (ex != null) {
                            LogManager.logDetail((String)"org.teiid.RUNTIME", ex, (Object)"Failed to get metadata, trying next source.");
                            ex = null;
                            te = null;
                        }
                        try {
                            if (cm != null) {
                                ef = cm.getExecutionFactory();
                                cf = cm.getConnectionFactory();
                            }
                        }
                        catch (TranslatorException e) {
                            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)((Object)e), (Object)"Failed to get a connection factory for metadata load.");
                            te = e;
                        }
                        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                        try {
                            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50104, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), cm != null ? cm.getTranslatorName() : null, cm != null ? cm.getConnectionName() : null}));
                            Thread.currentThread().setContextClassLoader(metadataRepo.getClass().getClassLoader());
                            metadataRepo.loadMetadata(factory, ef, cf);
                            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50030, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), SimpleDateFormat.getInstance().format(new Date())}));
                            break;
                        }
                        catch (Exception e) {
                            factory = VDBService.this.createMetadataFactory(vdb, vdbMetadataStore, model, vdbResources.getEntriesPlusVisibilities());
                            ex = e;
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(originalCL);
                        }
                    }
                }
                VDBMetaData vDBMetaData = vdb;
                synchronized (vDBMetaData) {
                    VDBStatusChecker marked = (VDBStatusChecker)model.removeAttachment(VDBStatusChecker.class);
                    if (ex == null) {
                        if (!cached) {
                            VDBService.this.cacheMetadataStore(model, factory);
                        }
                        VDBService.this.metadataLoaded(vdb, model, vdbMetadataStore, loadCount, factory, true, cmr, vdbResources);
                    } else {
                        String errorMsg;
                        String string = errorMsg = ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage();
                        if (te != null) {
                            errorMsg = errorMsg + ": " + te.getMessage();
                        }
                        model.addRuntimeError(errorMsg);
                        model.setMetadataStatus(Model.MetadataStatus.FAILED);
                        LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)ex, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50036, new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), errorMsg}));
                        if (ex instanceof RuntimeException) {
                            VDBService.this.metadataLoaded(vdb, model, vdbMetadataStore, loadCount, factory, false, cmr, vdbResources);
                        } else if (marked != null) {
                            VDBService.this.getExecutor().execute(this);
                        } else {
                            model.addAttchment(Runnable.class, (Object)this);
                        }
                    }
                }
            }
        };
        Executor executor = this.getExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    job.run();
                }
                catch (IllegalStateException e) {
                    if (vdb.getStatus() != VDB.Status.FAILED && vdb.getStatus() != VDB.Status.REMOVED) {
                        throw e;
                    }
                    LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)e, (Object)"Could not load metadata for a removed or failed deployment.");
                }
            }
        });
    }

    private void cacheMetadataStore(ModelMetaData model, MetadataFactory schema) {
        String prop;
        boolean cache = true;
        if (this.vdb.isXmlDeployment() && (cache = "cached".equalsIgnoreCase(this.vdb.getPropertyValue("UseConnectorMetadata")))) {
            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)"using VDB metadata caching value", (Object)this.vdb.getPropertyValue("UseConnectorMetadata"), (Object)"Note that UseConnectorMetadata is deprecated.  Use cache-metadata instead.");
        }
        if ((prop = this.vdb.getPropertyValue("cache-metadata")) != null) {
            cache = Boolean.valueOf(prop);
        }
        if ((prop = model.getPropertyValue("cache-metadata")) != null) {
            LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)model, (Object)"using metadata caching value", (Object)prop);
            cache = Boolean.valueOf(prop);
        }
        if (cache) {
            File cachedFile = this.getSerializer().buildModelFile(this.vdb, model.getName());
            try {
                this.getSerializer().saveAttachment(cachedFile, schema, false);
            }
            catch (Exception e) {
                LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50044, new Object[]{this.vdb.getName(), this.vdb.getVersion(), model.getName()}));
            }
        }
    }

    private void deleteModelCache(String modelName) {
        File cachedFile = this.getSerializer().buildModelFile(this.vdb, modelName);
        this.getSerializer().removeAttachment(cachedFile);
    }

    protected VDBRepository getVDBRepository() {
        return (VDBRepository)this.vdbRepositoryInjector.getValue();
    }

    private TranslatorRepository getTranslatorRepository() {
        return (TranslatorRepository)this.translatorRepositoryInjector.getValue();
    }

    private Executor getExecutor() {
        return (Executor)this.executorInjector.getValue();
    }

    private ObjectSerializer getSerializer() {
        return (ObjectSerializer)this.serializerInjector.getValue();
    }

    private void save() throws AdminProcessingException {
        try {
            ObjectSerializer os = this.getSerializer();
            VDBMetadataParser.marshell((VDBMetaData)this.vdb, (OutputStream)os.getVdbXmlOutputStream(this.vdb));
        }
        catch (IOException e) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50048, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new AdminProcessingException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50049, (Throwable)e);
        }
    }

    protected MetadataRepository<?, ?> getMetadataRepository(String repoType) throws VirtualDatabaseException {
        MetadataRepository repo = super.getMetadataRepository(repoType);
        if (repo != null) {
            return repo;
        }
        try {
            repo = TeiidAdd.loadService(MetadataRepository.class, repoType, (ServiceModuleLoader)this.vdb.getAttachment(ServiceModuleLoader.class));
            repo = TeiidAdd.wrapWithClassLoaderProxy(MetadataRepository.class, repo);
        }
        catch (OperationFailedException e) {
            throw new VirtualDatabaseException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50057, (Exception)((Object)e), IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50057, new Object[]{repoType}));
        }
        MetadataRepository old = this.repositories.putIfAbsent(repoType, repo);
        return old != null ? old : repo;
    }
}

