/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.oauth;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.saml.Saml2BearerGrant;
import org.teiid.jboss.oauth.OAuth20CredentialImpl;
import org.teiid.jboss.oauth.OAuth20LoginModule;

public abstract class SAMLBearerTokenLoginModule
extends OAuth20LoginModule {
    private String scope;

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, handler, sharedState, options);
        this.scope = (String)options.get("scope");
    }

    @Override
    public boolean login() throws LoginException {
        this.callerSubject = SAMLBearerTokenLoginModule.getSubject();
        this.callerPrincipal = SAMLBearerTokenLoginModule.getPrincipal();
        final String samlToken = this.getSAMLResponseToken();
        if (samlToken == null) {
            return false;
        }
        OAuth20CredentialImpl cred = new OAuth20CredentialImpl(){

            @Override
            protected ClientAccessToken getAccessToken() {
                Consumer consumer = new Consumer(this.getClientId(), this.getClientSecret());
                WebClient client = WebClient.create((String)this.getAccessTokenURI());
                Saml2BearerGrant grant = null;
                grant = SAMLBearerTokenLoginModule.this.scope != null ? new Saml2BearerGrant(samlToken, SAMLBearerTokenLoginModule.this.scope) : new Saml2BearerGrant(samlToken);
                return OAuthClientUtils.getAccessToken((WebClient)client, (Consumer)consumer, (AccessTokenGrant)grant, null, (boolean)false);
            }
        };
        cred.setClientId(this.getClientId());
        cred.setClientSecret(this.getClientSecret());
        cred.setAccessTokenURI(this.getAccessTokenURI());
        this.setCredential(cred);
        return super.login();
    }

    public abstract String getSAMLResponseToken();
}

