/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.oauth;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.refresh.RefreshTokenGrant;
import org.teiid.OAuthCredential;

public class OAuth20CredentialImpl
implements OAuthCredential {
    private String clientId;
    private String clientSecret;
    private String refreshToken;
    private String accessTokenURI;
    private String accessTokenString;
    private ClientAccessToken accessToken;

    public String getAuthorizationHeader(String resourceURI, String httpMethod) {
        if (this.accessToken == null || this.expired(this.accessToken)) {
            this.accessToken = this.getAccessToken();
        }
        return "Bearer " + this.accessToken.getTokenKey();
    }

    public String getAuthrorizationProperty(String key) {
        if (this.accessToken == null || this.expired(this.accessToken)) {
            this.accessToken = this.getAccessToken();
        }
        return (String)this.accessToken.getParameters().get(key);
    }

    private boolean expired(ClientAccessToken token) {
        if (token.getExpiresIn() != -1L) {
            return token.getIssuedAt() + token.getExpiresIn() - System.currentTimeMillis() < 0L;
        }
        return false;
    }

    protected ClientAccessToken getAccessToken() {
        if (this.getAccessTokenString() != null) {
            return new ClientAccessToken("token_type", this.getAccessTokenString());
        }
        Consumer consumer = new Consumer(this.getClientId(), this.getClientSecret());
        WebClient client = WebClient.create((String)this.getAccessTokenURI());
        RefreshTokenGrant grant = new RefreshTokenGrant(this.getRefreshToken());
        return OAuthClientUtils.getAccessToken((WebClient)client, (Consumer)consumer, (AccessTokenGrant)grant, null, (String)"Bearer", (boolean)false);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getAccessTokenURI() {
        return this.accessTokenURI;
    }

    public void setAccessTokenURI(String accessTokenURI) {
        this.accessTokenURI = accessTokenURI;
    }

    public String getAccessTokenString() {
        return this.accessTokenString;
    }

    public void setAccessTokenString(String accessTokenString) {
        this.accessTokenString = accessTokenString;
    }
}

