/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.oauth;

import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Signature;
import java.text.MessageFormat;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.jwt.JwtBearerGrant;
import org.jboss.security.JBossJSSESecurityDomain;
import org.teiid.core.util.Base64;
import org.teiid.jboss.oauth.OAuth20CredentialImpl;
import org.teiid.jboss.oauth.OAuth20LoginModule;
import org.teiid.logging.LogManager;

public class JWTBearerTokenLoginModule
extends OAuth20LoginModule {
    private String scope;
    private String issuer;
    private String audience;
    private String subject;
    private String keystoreType;
    private String keystorePassword;
    private String keystoreURL;
    private String certificateAlias;
    private String certificatePassword;
    private String algorithamName;
    private static JBossJSSESecurityDomain securityDomain;

    @Override
    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, handler, sharedState, options);
        this.scope = (String)options.get("scope");
        this.issuer = (String)options.get("jwt-issuer");
        this.audience = (String)options.get("jwt-audience");
        this.subject = (String)options.get("jwt-subject");
        this.keystoreType = (String)options.get("keystore-type");
        this.keystorePassword = (String)options.get("keystore-password");
        this.keystoreURL = (String)options.get("keystore-url");
        this.certificateAlias = (String)options.get("certificate-alias");
        this.certificatePassword = (String)options.get("certificate-password");
        this.algorithamName = (String)options.get("signature-algorithm-name");
    }

    @Override
    public boolean login() throws LoginException {
        this.callerSubject = JWTBearerTokenLoginModule.getSubject();
        this.callerPrincipal = JWTBearerTokenLoginModule.getPrincipal();
        final String assertion = this.getJWTAssertion();
        if (assertion == null) {
            return false;
        }
        OAuth20CredentialImpl cred = new OAuth20CredentialImpl(){

            @Override
            protected ClientAccessToken getAccessToken() {
                Consumer consumer = new Consumer(this.getClientId(), this.getClientSecret());
                WebClient client = WebClient.create((String)this.getAccessTokenURI());
                JwtBearerGrant grant = null;
                grant = JWTBearerTokenLoginModule.this.scope != null ? new JwtBearerGrant(assertion, true, JWTBearerTokenLoginModule.this.scope) : new JwtBearerGrant(assertion, true);
                return OAuthClientUtils.getAccessToken((WebClient)client, (Consumer)consumer, (AccessTokenGrant)grant, null, (boolean)false);
            }
        };
        cred.setClientId(this.getClientId());
        cred.setClientSecret(this.getClientSecret());
        cred.setAccessTokenURI(this.getAccessTokenURI());
        this.setCredential(cred);
        return super.login();
    }

    protected String getJWTAssertion() throws LoginException {
        String header = "{\"alg\":\"RS256\"}";
        String claimTemplate = "'{'\"iss\": \"{0}\", \"sub\": \"{1}\", \"aud\": \"{2}\", \"exp\": \"{3}\"'}'";
        StringBuffer token = new StringBuffer();
        try {
            token.append(Base64.encodeUrlSafe((byte[])header.getBytes("UTF-8")));
            token.append(".");
            String[] claimArray = new String[]{this.issuer == null ? this.getClientId() : this.issuer, this.subject == null ? this.callerPrincipal.getName() : this.subject, this.audience, Long.toString(System.currentTimeMillis() / 1000L + 120L)};
            MessageFormat claims = new MessageFormat(claimTemplate);
            String payload = claims.format(claimArray);
            token.append(Base64.encodeUrlSafe((byte[])payload.getBytes("UTF-8")));
            String password = this.certificatePassword == null ? this.keystorePassword : this.certificatePassword;
            JWTBearerTokenLoginModule.loadKeystore(this.keystoreURL, this.keystorePassword, this.keystoreType, password);
            Key key = securityDomain.getKey(this.certificateAlias, password);
            Signature signature = Signature.getInstance(this.algorithamName == null ? "SHA256withRSA" : this.algorithamName);
            signature.initSign((PrivateKey)key);
            signature.update(token.toString().getBytes("UTF-8"));
            String signedPayload = Base64.encodeUrlSafe((byte[])signature.sign());
            token.append(".");
            token.append(signedPayload);
            return token.toString();
        }
        catch (Exception e) {
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object)e);
            throw new LoginException(e.getMessage());
        }
    }

    private static void loadKeystore(String keystoreURL, String keystorePassword, String keystoreType, String password) throws Exception, IOException {
        if (securityDomain == null) {
            securityDomain = new JBossJSSESecurityDomain("JWTBearer");
            securityDomain.setKeyStorePassword(keystorePassword);
            securityDomain.setKeyStoreType(keystoreType == null ? "JKS" : keystoreType);
            securityDomain.setKeyStoreURL(keystoreURL);
            securityDomain.setServiceAuthToken(password);
            securityDomain.reloadKeyAndTrustStore();
        }
    }
}

