/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.NavigableMap;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.query.metadata.TransformationMetadata;

public class TestMultipleModelIndexes {
    @Test
    public void testMultiple() throws Exception {
        TransformationMetadata tm = VDBMetadataFactory.getVDBMetadata(UnitTestUtil.getTestDataPath() + "/ZZZ.vdb");
        Collection names = tm.getGroupsForPartialName("PRODUCTDATA");
        Assert.assertEquals((long)1L, (long)names.size());
        names = tm.getGroupsForPartialName("PARTS");
        Assert.assertEquals((long)1L, (long)names.size());
        Table t = tm.getGroupID((String)names.iterator().next());
        Assert.assertNotNull((Object)((Column)t.getColumns().get(0)).getDatatype());
    }

    @Test
    public void testUniqueReferencedKey() throws Exception {
        TransformationMetadata tm = VDBMetadataFactory.getVDBMetadata(UnitTestUtil.getTestDataPath() + "/keys.vdb");
        Collection fks = tm.getForeignKeysInGroup((Object)tm.getGroupID("x.a"));
        Assert.assertEquals((long)1L, (long)fks.size());
        Object pk = tm.getPrimaryKeyIDForForeignKeyID(fks.iterator().next());
        Assert.assertNotNull((Object)pk);
    }

    @Test
    public void testIndex() throws Exception {
        TransformationMetadata tm = VDBMetadataFactory.getVDBMetadata(UnitTestUtil.getTestDataPath() + "/ora.vdb");
        Collection indexes = tm.getIndexesInGroup((Object)tm.getGroupID("ORACLE_BQT.SMALLA"));
        Assert.assertEquals((long)1L, (long)indexes.size());
    }

    @Test
    public void testSchemaLoad() throws Exception {
        TransformationMetadata tm = VDBMetadataFactory.getVDBMetadata(UnitTestUtil.getTestDataPath() + "/Test.vdb");
        Table t = tm.getGroupID("Northwind.Northwind.dbo.Employees");
        Assert.assertFalse((boolean)t.isVirtual());
    }

    @Test
    public void test81Schema() throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(UnitTestUtil.getTestDataFile((String)"schema.ser")));
        Schema schema = (Schema)ois.readObject();
        Assert.assertNotNull((Object)schema.getFunctions());
    }

    @Test
    public void testFunctionMetadata() throws Exception {
        TransformationMetadata tm = VDBMetadataFactory.getVDBMetadata(UnitTestUtil.getTestDataPath() + "/TEIIDDES992_VDB.vdb");
        NavigableMap functions = tm.getMetadataStore().getSchema("TEIIDDES992").getFunctions();
        Assert.assertEquals((long)1L, (long)functions.size());
        FunctionMethod fm = (FunctionMethod)functions.values().iterator().next();
        Assert.assertEquals((Object)"sampleFunction", (Object)fm.getName());
        Assert.assertEquals((long)1L, (long)fm.getInputParameters().size());
    }
}

