/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.index;

import java.io.IOException;
import org.teiid.core.index.IEntryResult;
import org.teiid.core.index.IIndex;
import org.teiid.core.index.IQueryResult;
import org.teiid.internal.core.index.BlocksIndexInput;
import org.teiid.metadata.VDBResource;

public class Index
implements IIndex {
    public static final int MAX_FOOTPRINT = 10000000;
    private VDBResource indexFile;
    private BlocksIndexInput cachedInput;
    protected boolean doCache = false;
    private String resourceFileName;
    public String toString;

    public Index(VDBResource f) throws IOException {
        this.indexFile = f;
        this.initialize();
    }

    @Override
    public int getNumDocuments() throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            input.open();
            int n = input.getNumFiles();
            return n;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    @Override
    public int getNumWords() throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            input.open();
            int n = input.getNumWords();
            return n;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws IOException {
        BlocksIndexInput mainIndexInput = this.getBlocksIndexInput();
        try {
            mainIndexInput.open();
        }
        catch (IOException e) {
            BlocksIndexInput input = mainIndexInput;
            try {
                input.setOpen(true);
                input.close();
            }
            finally {
                input.setOpen(false);
            }
            mainIndexInput = null;
            throw e;
        }
        if (!this.doCache) {
            mainIndexInput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQueryResult[] query(String word) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IQueryResult[] iQueryResultArray = input.query(word);
            return iQueryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IEntryResult[] queryEntries(char[] prefix) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IEntryResult[] iEntryResultArray = input.queryEntriesPrefixedBy(prefix);
            return iEntryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IQueryResult[] iQueryResultArray = input.queryInDocumentNames(word);
            return iQueryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQueryResult[] queryPrefix(char[] prefix) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IQueryResult[] iQueryResultArray = input.queryFilesReferringToPrefix(prefix);
            return iQueryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntryResult[] queryEntriesMatching(char[] prefix, boolean isCaseSensitive) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IEntryResult[] iEntryResultArray = input.queryEntriesMatching(prefix, isCaseSensitive);
            return iEntryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEntryResult[] queryEntries(char[] prefix, boolean isCaseSensitive) throws IOException {
        BlocksIndexInput input = this.getBlocksIndexInput();
        try {
            IEntryResult[] iEntryResultArray = input.queryEntriesPrefixedBy(prefix, isCaseSensitive);
            return iEntryResultArray;
        }
        finally {
            if (!this.doCache) {
                input.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected BlocksIndexInput getBlocksIndexInput() {
        if (!this.doCache) return new BlocksIndexInput(this.indexFile);
        if (this.getCachedInput() != null) return this.getCachedInput();
        boolean wasLoaded = false;
        try {
            if (this.getCachedInput() != null) return new BlocksIndexInput(this.indexFile);
            this.setCachedInput(new BlocksIndexInput(this.indexFile));
            this.getCachedInput().open();
            wasLoaded = true;
            return new BlocksIndexInput(this.indexFile);
        }
        catch (IOException iOException) {
            return new BlocksIndexInput(this.indexFile);
        }
        finally {
            if (wasLoaded && this.getCachedInput() != null) {
                return this.getCachedInput();
            }
            this.setCachedInput(null);
        }
    }

    @Override
    public void close() {
        if (this.getCachedInput() != null) {
            try {
                this.getCachedInput().close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.setCachedInput(null);
            }
        }
    }

    public String toString() {
        String str = this.toString;
        if (str == null) {
            str = super.toString();
        }
        str = str + "(length: " + this.indexFile.getSize() + ")";
        return str;
    }

    @Override
    public void setDoCache(boolean theDoCache) {
        this.doCache = theDoCache;
    }

    public BlocksIndexInput getCachedInput() {
        return this.cachedInput;
    }

    public void setCachedInput(BlocksIndexInput theCachedInput) {
        this.cachedInput = theCachedInput;
    }

    public String getResourceFileName() {
        return this.resourceFileName;
    }
}

