/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.index;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.teiid.internal.core.index.CharOperation;
import org.teiid.internal.core.index.IndexedFile;
import org.teiid.internal.core.index.Util;

public class IndexSummary {
    protected ArrayList firstFilesInBlocks = new ArrayList();
    protected ArrayList firstWordsInBlocks = new ArrayList();
    protected int numFiles;
    protected int numWords;
    protected int firstWordBlockNum;
    protected boolean firstWordAdded = true;

    public void addFirstFileInBlock(IndexedFile indexedFile, int blockNum) {
        FirstFileInBlock entry = new FirstFileInBlock();
        entry.indexedFile = indexedFile;
        entry.blockNum = blockNum;
        this.firstFilesInBlocks.add(entry);
    }

    public void addFirstWordInBlock(char[] word, int blockNum) {
        if (this.firstWordAdded) {
            this.firstWordBlockNum = blockNum;
            this.firstWordAdded = false;
        }
        FirstWordInBlock entry = new FirstWordInBlock();
        entry.word = word;
        entry.blockNum = blockNum;
        this.firstWordsInBlocks.add(entry);
    }

    public int[] getAllBlockNums() {
        int max = this.firstWordsInBlocks.size();
        int[] blockNums = new int[max];
        for (int i = 0; i < max; ++i) {
            blockNums[i] = ((FirstWordInBlock)this.firstWordsInBlocks.get((int)i)).blockNum;
        }
        return blockNums;
    }

    public int getBlockNum(int blockLocation) {
        return ((FirstWordInBlock)this.firstWordsInBlocks.get((int)blockLocation)).blockNum;
    }

    public int getBlockNumForFileNum(int fileNum) {
        int min = 0;
        int max = this.firstFilesInBlocks.size() - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            FirstFileInBlock entry = (FirstFileInBlock)this.firstFilesInBlocks.get(mid);
            int compare = fileNum - entry.indexedFile.getFileNumber();
            if (compare == 0) {
                return entry.blockNum;
            }
            if (compare < 0) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        if (max < 0) {
            return -1;
        }
        FirstFileInBlock entry = (FirstFileInBlock)this.firstFilesInBlocks.get(max);
        return entry.blockNum;
    }

    public int getBlockNumForWord(char[] word) {
        int min = 0;
        int max = this.firstWordsInBlocks.size() - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            FirstWordInBlock entry = (FirstWordInBlock)this.firstWordsInBlocks.get(mid);
            int compare = Util.compare(word, entry.word);
            if (compare == 0) {
                return entry.blockNum;
            }
            if (compare < 0) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        if (max < 0) {
            return -1;
        }
        FirstWordInBlock entry = (FirstWordInBlock)this.firstWordsInBlocks.get(max);
        return entry.blockNum;
    }

    public int[] getBlockNumsForPrefix(char[] prefix) {
        int firstNotIncludedBlock;
        int firstBlock;
        FirstWordInBlock entry;
        int min = 0;
        int size = this.firstWordsInBlocks.size();
        int max = size - 1;
        int match = -1;
        while (min <= max && match < 0) {
            int mid = (min + max) / 2;
            entry = (FirstWordInBlock)this.firstWordsInBlocks.get(mid);
            int compare = IndexSummary.compareWith(entry.word, prefix, true);
            if (compare == 0) {
                match = mid;
                break;
            }
            if (compare >= 0) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        if (max < 0) {
            return new int[0];
        }
        if (match < 0) {
            match = max;
        }
        for (firstBlock = match - 1; firstBlock >= 0; --firstBlock) {
            entry = (FirstWordInBlock)this.firstWordsInBlocks.get(firstBlock);
            if (!CharOperation.prefixEquals(prefix, entry.word, true)) break;
        }
        if (firstBlock < 0) {
            firstBlock = 0;
        }
        for (firstNotIncludedBlock = match + 1; firstNotIncludedBlock < size; ++firstNotIncludedBlock) {
            FirstWordInBlock entry2 = (FirstWordInBlock)this.firstWordsInBlocks.get(firstNotIncludedBlock);
            if (!CharOperation.prefixEquals(prefix, entry2.word, true)) break;
        }
        int numberOfBlocks = firstNotIncludedBlock - firstBlock;
        int[] result = new int[numberOfBlocks];
        int pos = firstBlock;
        int i = 0;
        while (i < numberOfBlocks) {
            FirstWordInBlock entry3 = (FirstWordInBlock)this.firstWordsInBlocks.get(pos);
            result[i] = entry3.blockNum;
            ++i;
            ++pos;
        }
        return result;
    }

    public int getFirstBlockLocationForPrefix(char[] prefix) {
        int min = 0;
        int size = this.firstWordsInBlocks.size();
        int max = size - 1;
        int match = -1;
        while (min <= max) {
            int mid = (min + max) / 2;
            FirstWordInBlock entry = (FirstWordInBlock)this.firstWordsInBlocks.get(mid);
            int compare = IndexSummary.compareWith(entry.word, prefix, false);
            if (compare == 0) {
                match = mid;
                break;
            }
            if (compare >= 0) {
                max = mid - 1;
                continue;
            }
            match = mid;
            min = mid + 1;
        }
        if (max < 0) {
            return -1;
        }
        if (match < 0) {
            match = max;
        } else {
            while (match > 0) {
                FirstWordInBlock entry = (FirstWordInBlock)this.firstWordsInBlocks.get(match);
                if (!CharOperation.prefixEquals(prefix, entry.word, true)) break;
                --match;
            }
        }
        return match;
    }

    static final int compareWith(char[] array, char[] prefix, boolean caseSensitive) {
        int arrayLength = array.length;
        int prefixLength = prefix.length;
        int min = Math.min(arrayLength, prefixLength);
        int i = 0;
        while (min-- != 0) {
            char c2;
            int diff;
            char c1 = array[i];
            if ((diff = c1 - (c2 = prefix[i++])) == 0 || !caseSensitive && Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return diff;
        }
        if (prefixLength == i) {
            return 0;
        }
        return -1;
    }

    public int getFirstWordBlockNum() {
        return this.firstWordBlockNum;
    }

    public int getNextBlockLocationForPrefix(char[] prefix, int blockLoc) {
        if (++blockLoc < this.firstWordsInBlocks.size()) {
            FirstWordInBlock entry = (FirstWordInBlock)this.firstWordsInBlocks.get(blockLoc);
            if (CharOperation.prefixEquals(prefix, entry.word, true)) {
                return blockLoc;
            }
        }
        return -1;
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    public int getNumWords() {
        return this.numWords;
    }

    public void read(RandomAccessFile raf) throws IOException {
        this.numFiles = raf.readInt();
        this.numWords = raf.readInt();
        this.firstWordBlockNum = raf.readInt();
        int numFirstFiles = raf.readInt();
        for (int i = 0; i < numFirstFiles; ++i) {
            FirstFileInBlock entry = new FirstFileInBlock();
            String path = raf.readUTF();
            int fileNum = raf.readInt();
            entry.indexedFile = new IndexedFile(path, fileNum);
            entry.blockNum = raf.readInt();
            this.firstFilesInBlocks.add(entry);
        }
        int numFirstWords = raf.readInt();
        for (int i = 0; i < numFirstWords; ++i) {
            FirstWordInBlock entry = new FirstWordInBlock();
            entry.word = raf.readUTF().toCharArray();
            entry.blockNum = raf.readInt();
            this.firstWordsInBlocks.add(entry);
        }
    }

    public void setNumFiles(int numFiles) {
        this.numFiles = numFiles;
    }

    public void setNumWords(int numWords) {
        this.numWords = numWords;
    }

    public void write(RandomAccessFile raf) throws IOException {
        Object entry;
        int i;
        raf.writeInt(this.numFiles);
        raf.writeInt(this.numWords);
        raf.writeInt(this.firstWordBlockNum);
        raf.writeInt(this.firstFilesInBlocks.size());
        int size = this.firstFilesInBlocks.size();
        for (i = 0; i < size; ++i) {
            entry = (FirstFileInBlock)this.firstFilesInBlocks.get(i);
            raf.writeUTF(((FirstFileInBlock)entry).indexedFile.getPath());
            raf.writeInt(((FirstFileInBlock)entry).indexedFile.getFileNumber());
            raf.writeInt(((FirstFileInBlock)entry).blockNum);
        }
        raf.writeInt(this.firstWordsInBlocks.size());
        size = this.firstWordsInBlocks.size();
        for (i = 0; i < size; ++i) {
            entry = (FirstWordInBlock)this.firstWordsInBlocks.get(i);
            raf.writeUTF(new String(((FirstWordInBlock)entry).word));
            raf.writeInt(((FirstWordInBlock)entry).blockNum);
        }
    }

    static class FirstWordInBlock {
        char[] word;
        int blockNum;

        FirstWordInBlock() {
        }

        public String toString() {
            return "FirstWordInBlock: " + new String(this.word) + ", blockNum: " + this.blockNum;
        }
    }

    static class FirstFileInBlock {
        IndexedFile indexedFile;
        int blockNum;

        FirstFileInBlock() {
        }
    }
}

