/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.web.gzip;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.olingo.web.gzip.GzipFilter;
import org.teiid.olingo.web.gzip.GzipMessageRequest;
import org.teiid.olingo.web.gzip.GzipMessageResponse;

public class TestGzipFilter {
    @Test
    public void testUseGzipMessageRequest() throws IOException, ServletException {
        HttpServletRequest req = this.mockRequest("GZIP", "deflate");
        HttpServletResponse res = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        new GzipFilter().doFilter((ServletRequest)req, (ServletResponse)res, chain);
        ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)Mockito.any(GzipMessageRequest.class), (ServletResponse)Mockito.same((Object)res));
        ((HttpServletRequest)Mockito.verify((Object)req, (VerificationMode)Mockito.times((int)2))).getHeader(Mockito.anyString());
        ((HttpServletRequest)Mockito.verify((Object)req)).getCharacterEncoding();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{chain, req, res});
    }

    @Test
    public void testUseGzipMessageResponse() throws IOException, ServletException {
        HttpServletRequest req = this.mockRequest(null, "deflate,GZIP");
        HttpServletResponse res = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        new GzipFilter().doFilter((ServletRequest)req, (ServletResponse)res, chain);
        ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)Mockito.same((Object)req), (ServletResponse)Mockito.any(GzipMessageResponse.class));
        ((HttpServletRequest)Mockito.verify((Object)req, (VerificationMode)Mockito.times((int)2))).getHeader(Mockito.anyString());
        ((HttpServletResponse)Mockito.verify((Object)res)).getCharacterEncoding();
        ((HttpServletResponse)Mockito.verify((Object)res)).setHeader((String)Mockito.argThat((Matcher)new IgnoreCaseStringMatcher("Content-Encoding")), (String)Mockito.argThat((Matcher)new IgnoreCaseStringMatcher("gzip")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{chain, req, res});
    }

    @Test
    public void testNoInteraction() throws IOException, ServletException {
        HttpServletRequest req = this.mockRequest(null, null);
        HttpServletResponse res = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        new GzipFilter().doFilter((ServletRequest)req, (ServletResponse)res, chain);
        ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)Mockito.same((Object)req), (ServletResponse)Mockito.same((Object)res));
    }

    private HttpServletRequest mockRequest(String contentEncoding, String acceptEncoding) {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)contentEncoding).when((Object)req)).getHeader((String)Mockito.argThat((Matcher)new IgnoreCaseStringMatcher("Content-Encoding")));
        ((HttpServletRequest)Mockito.doReturn((Object)acceptEncoding).when((Object)req)).getHeader((String)Mockito.argThat((Matcher)new IgnoreCaseStringMatcher("Accept-Encoding")));
        return req;
    }

    private class IgnoreCaseStringMatcher
    extends BaseMatcher<String> {
        private final String toMatch;

        private IgnoreCaseStringMatcher(String toMatch) {
            this.toMatch = toMatch;
        }

        public boolean matches(Object item) {
            return this.toMatch.equalsIgnoreCase(Objects.toString(item));
        }

        public void describeTo(Description description) {
            description.appendText(this.toMatch);
        }
    }
}

