/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.web.gzip;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.olingo.web.gzip.GzipMessageRequest;
import org.teiid.olingo.web.gzip.TestGzipMessageResponse;

public class TestGzipMessageRequest {
    private GzipMessageRequest request;
    private ServletInputStream stream;
    private ByteArrayInputStream streamBytes;

    @Before
    public void prepareRequest() throws IOException {
        this.streamBytes = new ByteArrayInputStream(TestGzipMessageResponse.TEST_STRING_IN_GZIP);
        this.stream = new ServletInputStream(){

            public boolean isReady() {
                return true;
            }

            public boolean isFinished() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return TestGzipMessageRequest.this.streamBytes.read();
            }
        };
        this.request = new GzipMessageRequest(TestGzipMessageRequest.mockRequest(this.stream));
    }

    @Test
    public void testIllegalGetInputStreamInvocation() throws IOException {
        this.request.getReader();
        try {
            this.request.getInputStream();
            Assert.fail((String)("Expected " + IllegalStateException.class));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testIllegalGetReaderInvocation() throws IOException {
        this.request.getInputStream();
        try {
            this.request.getReader();
            Assert.fail((String)("Expected " + IllegalStateException.class));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testReadFromReader() throws IOException {
        BufferedReader r = this.request.getReader();
        String read = r.readLine();
        Assert.assertEquals((String)"Expected read String.", (Object)"test string", (Object)read);
        Assert.assertNull((String)"No next line expected.", (Object)r.readLine());
        Assert.assertEquals((String)"There should be no more bytes in stream.", (long)0L, (long)this.streamBytes.available());
    }

    @Test
    public void testReadFromInputStream() throws Exception {
        ServletInputStream sis = this.request.getInputStream();
        byte[] buff = new byte["test string".getBytes().length];
        sis.read(buff);
        Assert.assertEquals((String)"Expected String output.", (Object)"test string", (Object)new String(buff));
        Assert.assertEquals((String)"There should be no more bytes in stream.", (long)0L, (long)this.streamBytes.available());
    }

    private static HttpServletRequest mockRequest(ServletInputStream stream) throws IOException {
        HttpServletRequest out = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)stream).when((Object)out)).getInputStream();
        ((HttpServletRequest)Mockito.doThrow(Error.class).when((Object)out)).getReader();
        return out;
    }
}

