/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlOperation;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlCollection;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlConstantExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.common.ODataTypeManager;

public class ODataSchemaBuilder {
    public static CsdlSchema buildMetadata(String namespace, Schema teiidSchema) {
        try {
            CsdlSchema csdlSchema = new CsdlSchema();
            String fullSchemaName = namespace + "." + teiidSchema.getName();
            csdlSchema.setNamespace(fullSchemaName).setAlias(teiidSchema.getName());
            ODataSchemaBuilder.buildEntityTypes(namespace, teiidSchema, csdlSchema);
            ODataSchemaBuilder.buildProcedures(teiidSchema, csdlSchema);
            return csdlSchema;
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    static CsdlEntitySet findEntitySet(CsdlSchema edmSchema, String enitityName) {
        CsdlEntityContainer entityContainter = edmSchema.getEntityContainer();
        for (CsdlEntitySet entitySet : entityContainter.getEntitySets()) {
            if (!entitySet.getName().equalsIgnoreCase(enitityName)) continue;
            return entitySet;
        }
        return null;
    }

    static CsdlSchema findSchema(Map<String, CsdlSchema> edmSchemas, String schemaName) {
        return edmSchemas.get(schemaName);
    }

    static CsdlEntityType findEntityType(Map<String, CsdlSchema> edmSchemas, String schemaName, String enitityName) {
        CsdlSchema schema = ODataSchemaBuilder.findSchema(edmSchemas, schemaName);
        if (schema != null) {
            for (CsdlEntityType type : schema.getEntityTypes()) {
                if (!type.getName().equalsIgnoreCase(enitityName)) continue;
                return type;
            }
        }
        return null;
    }

    static CsdlEntityContainer findEntityContainer(Map<String, CsdlSchema> edmSchemas, String schemaName) {
        CsdlSchema schema = edmSchemas.get(schemaName);
        return schema.getEntityContainer();
    }

    static void buildEntityTypes(String namespace, Schema schema, CsdlSchema csdlSchema) {
        LinkedHashMap<String, CsdlEntitySet> entitySets = new LinkedHashMap<String, CsdlEntitySet>();
        LinkedHashMap<String, CsdlEntityType> entityTypes = new LinkedHashMap<String, CsdlEntityType>();
        String fullSchemaName = namespace + "." + schema.getName();
        for (Table table : schema.getTables().values()) {
            Object c2;
            KeyRecord primaryKey = ODataSchemaBuilder.getIdentifier(table);
            if (primaryKey == null) {
                LogManager.logDetail((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16017, new Object[]{table.getFullName()}));
                continue;
            }
            String entityTypeName = table.getName();
            CsdlEntityType entityType = new CsdlEntityType().setName(entityTypeName);
            ArrayList<CsdlProperty> properties = new ArrayList<CsdlProperty>();
            for (Object c2 : table.getColumns()) {
                boolean nullable = c2.getNullType() == BaseColumn.NullType.Nullable;
                CsdlProperty property = ODataSchemaBuilder.buildProperty((Column)c2, ODataSchemaBuilder.isPartOfPrimaryKey(table, c2.getName()) ? false : nullable);
                ODataSchemaBuilder.addColumnAnnotations((Column)c2, property, csdlSchema);
                properties.add(property);
            }
            entityType.setProperties(properties);
            if (ODataSchemaBuilder.hasStream(properties)) {
                entityType.setHasStream(true);
            }
            ArrayList<CsdlPropertyRef> keyProps = new ArrayList<CsdlPropertyRef>();
            c2 = primaryKey.getColumns().iterator();
            while (c2.hasNext()) {
                Column c3 = (Column)c2.next();
                keyProps.add(new CsdlPropertyRef().setName(c3.getName()));
            }
            entityType.setKey(keyProps);
            ODataSchemaBuilder.addTableAnnotations(table, entityType, csdlSchema);
            CsdlEntitySet entitySet = new CsdlEntitySet().setName(table.getName()).setType(new FullQualifiedName(fullSchemaName, table.getName())).setIncludeInServiceDocument(true);
            entityTypes.put(entityTypeName, entityType);
            entitySets.put(entityTypeName, entitySet);
        }
        ODataSchemaBuilder.buildNavigationProperties(schema, entityTypes, entitySets);
        CsdlEntityContainer entityContainer = new CsdlEntityContainer().setName(schema.getName()).setEntitySets(new ArrayList(entitySets.values()));
        csdlSchema.setEntityTypes(new ArrayList(entityTypes.values())).setEntityContainer(entityContainer);
    }

    private static boolean hasStream(List<CsdlProperty> properties) {
        for (CsdlProperty p : properties) {
            if (!p.getType().equals(EdmPrimitiveTypeKind.Binary.getFullQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static CsdlProperty buildProperty(Column c, boolean nullable) {
        String runtimeType = c.getRuntimeType();
        CsdlProperty property = new CsdlProperty().setName(c.getName()).setType(ODataTypeManager.odataType((String)runtimeType).getFullQualifiedName()).setNullable(nullable);
        if (DataTypeManager.isArrayType((String)runtimeType)) {
            property.setCollection(true);
        }
        if ((runtimeType = ODataTypeManager.teiidType((String)property.getType(), (boolean)false)).equals("string") || runtimeType.equals("varbinary")) {
            property.setMaxLength(Integer.valueOf(c.getLength()));
            if (runtimeType.equals("string")) {
                property.setUnicode(true);
            }
        } else if (runtimeType.equals("bigdecimal") || runtimeType.equals("biginteger")) {
            if (c.getScale() < 0) {
                property.setPrecision(Integer.valueOf((int)Math.min(Integer.MAX_VALUE, (long)c.getPrecision() - (long)c.getScale())));
            } else {
                property.setPrecision(Integer.valueOf(c.getPrecision()));
            }
            property.setScale(Integer.valueOf(Math.max(0, c.getScale())));
        } else if (runtimeType.equals("timestamp") || runtimeType.equals("time")) {
            property.setPrecision(Integer.valueOf(c.getPrecision() == 0 ? new Integer(4).intValue() : c.getPrecision()));
        }
        if (c.getDefaultValue() != null) {
            property.setDefaultValue(c.getDefaultValue());
        }
        return property;
    }

    static boolean isPartOfPrimaryKey(Table table, String columnName) {
        KeyRecord pk = table.getPrimaryKey();
        if (ODataSchemaBuilder.hasColumn(pk, columnName)) {
            return true;
        }
        for (KeyRecord key : table.getUniqueKeys()) {
            if (!ODataSchemaBuilder.hasColumn(key, columnName)) continue;
            return true;
        }
        return false;
    }

    static boolean isPrimaryKey(Table table, List<String> columnNames) {
        KeyRecord pk = table.getPrimaryKey();
        boolean isPK = true;
        for (String columnName : columnNames) {
            if (ODataSchemaBuilder.hasColumn(pk, columnName)) continue;
            isPK = false;
            break;
        }
        if (!isPK) {
            for (KeyRecord key : table.getUniqueKeys()) {
                isPK = true;
                for (String columnName : columnNames) {
                    if (ODataSchemaBuilder.hasColumn(key, columnName)) continue;
                    isPK = false;
                }
                if (!isPK) continue;
                break;
            }
        }
        return isPK;
    }

    static boolean hasColumn(KeyRecord pk, String columnName) {
        if (pk != null) {
            for (Column column : pk.getColumns()) {
                if (!SQLStringVisitor.getRecordName((AbstractMetadataRecord)column).equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    static KeyRecord getIdentifier(Table table) {
        if (table.getPrimaryKey() != null) {
            return table.getPrimaryKey();
        }
        Iterator iterator = table.getUniqueKeys().iterator();
        if (iterator.hasNext()) {
            KeyRecord key = (KeyRecord)iterator.next();
            return key;
        }
        return null;
    }

    private static void buildNavigationProperties(Schema schema, Map<String, CsdlEntityType> entityTypes, Map<String, CsdlEntitySet> entitySets) {
        for (Table table : schema.getTables().values()) {
            if (ODataSchemaBuilder.getIdentifier(table) == null) continue;
            for (ForeignKey fk : table.getForeignKeys()) {
                boolean fkPKSame = ODataSchemaBuilder.sameColumnSet(ODataSchemaBuilder.getIdentifier(table), (KeyRecord)fk);
                boolean fkIsPK = ODataSchemaBuilder.isPrimaryKey(schema.getTable(fk.getReferenceTableName()), fk.getReferenceColumns());
                ODataSchemaBuilder.addForwardNavigation(entityTypes, entitySets, table, fk, fkPKSame || fkIsPK);
                ODataSchemaBuilder.addReverseNavigation(entityTypes, entitySets, table, fk, fkPKSame && fkIsPK);
            }
        }
    }

    private static void addForwardNavigation(Map<String, CsdlEntityType> entityTypes, Map<String, CsdlEntitySet> entitySets, Table table, ForeignKey fk, boolean onetoone) {
        CsdlNavigationProperty navigaton = null;
        CsdlNavigationPropertyBinding navigationBinding = null;
        String entityTypeName = null;
        entityTypeName = table.getName();
        navigaton = ODataSchemaBuilder.buildNavigation(fk);
        navigationBinding = ODataSchemaBuilder.buildNavigationBinding(fk);
        if (onetoone) {
            navigaton.setNullable(Boolean.valueOf(false));
        } else {
            navigaton.setCollection(true);
        }
        CsdlEntityType entityType = entityTypes.get(entityTypeName);
        entityType.getNavigationProperties().add(navigaton);
        CsdlEntitySet entitySet = entitySets.get(entityTypeName);
        entitySet.getNavigationPropertyBindings().add(navigationBinding);
    }

    private static void addReverseNavigation(Map<String, CsdlEntityType> entityTypes, Map<String, CsdlEntitySet> entitySets, Table table, ForeignKey fk, boolean onetoone) {
        CsdlNavigationProperty navigaton = null;
        CsdlNavigationPropertyBinding navigationBinding = null;
        String entityTypeName = null;
        entityTypeName = fk.getReferenceTableName();
        navigaton = ODataSchemaBuilder.buildReverseNavigation(table, fk);
        navigationBinding = ODataSchemaBuilder.buildReverseNavigationBinding(table, fk);
        if (onetoone) {
            navigaton.setNullable(Boolean.valueOf(false));
        } else {
            navigaton.setCollection(true);
        }
        CsdlEntityType entityType = entityTypes.get(entityTypeName);
        entityType.getNavigationProperties().add(navigaton);
        CsdlEntitySet entitySet = entitySets.get(entityTypeName);
        entitySet.getNavigationPropertyBindings().add(navigationBinding);
    }

    private static CsdlNavigationPropertyBinding buildNavigationBinding(ForeignKey fk) {
        CsdlNavigationPropertyBinding navigationBinding = new CsdlNavigationPropertyBinding();
        navigationBinding.setPath(fk.getName());
        navigationBinding.setTarget(fk.getReferenceTableName());
        return navigationBinding;
    }

    private static CsdlNavigationPropertyBinding buildReverseNavigationBinding(Table table, ForeignKey fk) {
        CsdlNavigationPropertyBinding navigationBinding = new CsdlNavigationPropertyBinding();
        navigationBinding.setPath(table.getName() + "_" + fk.getName());
        navigationBinding.setTarget(table.getName());
        return navigationBinding;
    }

    private static CsdlNavigationProperty buildNavigation(ForeignKey fk) {
        String refSchemaName = ((Schema)((Table)fk.getReferenceKey().getParent()).getParent()).getName();
        CsdlNavigationProperty navigaton = new CsdlNavigationProperty();
        navigaton.setName(fk.getName()).setType(new FullQualifiedName(refSchemaName, fk.getReferenceTableName()));
        ArrayList constrainsts = new ArrayList();
        for (int i = 0; i < fk.getColumns().size(); ++i) {
            Column c = (Column)fk.getColumns().get(i);
            String refColumn = (String)fk.getReferenceColumns().get(i);
            CsdlReferentialConstraint constraint = new CsdlReferentialConstraint();
            constraint.setProperty(c.getName());
            constraint.setReferencedProperty(refColumn);
        }
        navigaton.setReferentialConstraints(constrainsts);
        return navigaton;
    }

    private static CsdlNavigationProperty buildReverseNavigation(Table table, ForeignKey fk) {
        String refSchemaName = ((Schema)table.getParent()).getName();
        CsdlNavigationProperty navigaton = new CsdlNavigationProperty();
        navigaton.setName(table.getName() + "_" + fk.getName()).setType(new FullQualifiedName(refSchemaName, table.getName()));
        ArrayList constrainsts = new ArrayList();
        for (int i = 0; i < fk.getColumns().size(); ++i) {
            Column c = (Column)fk.getColumns().get(i);
            String refColumn = (String)fk.getReferenceColumns().get(i);
            CsdlReferentialConstraint constraint = new CsdlReferentialConstraint();
            constraint.setProperty(refColumn);
            constraint.setReferencedProperty(c.getName());
        }
        navigaton.setReferentialConstraints(constrainsts);
        return navigaton;
    }

    static void buildProcedures(Schema schema, CsdlSchema csdlSchema) {
        ArrayList<CsdlComplexType> complexTypes = new ArrayList<CsdlComplexType>();
        ArrayList<CsdlFunction> functions = new ArrayList<CsdlFunction>();
        ArrayList<CsdlFunctionImport> functionImports = new ArrayList<CsdlFunctionImport>();
        ArrayList<CsdlAction> actions = new ArrayList<CsdlAction>();
        ArrayList<CsdlActionImport> actionImports = new ArrayList<CsdlActionImport>();
        for (Procedure proc : schema.getProcedures().values()) {
            if (!ODataSchemaBuilder.allowedProcedure(proc)) {
                LogManager.logDetail((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16032, new Object[]{proc.getFullName()}));
                continue;
            }
            if (ODataSchemaBuilder.isFuntion(proc)) {
                ODataSchemaBuilder.buildFunction(schema.getName(), proc, complexTypes, functions, functionImports, csdlSchema);
                continue;
            }
            ODataSchemaBuilder.buildAction(schema.getName(), proc, complexTypes, actions, actionImports, csdlSchema);
        }
        csdlSchema.setComplexTypes(complexTypes);
        csdlSchema.setFunctions(functions);
        csdlSchema.setActions(actions);
        csdlSchema.getEntityContainer().setFunctionImports(functionImports);
        csdlSchema.getEntityContainer().setActionImports(actionImports);
    }

    private static boolean doesProcedureReturn(Procedure proc) {
        for (ProcedureParameter pp : proc.getParameters()) {
            if (!pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) continue;
            return true;
        }
        return proc.getResultSet() != null;
    }

    private static boolean allowedProcedure(Procedure proc) {
        int inouts = 0;
        int lobs = 0;
        int outs = 0;
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getType().equals((Object)ProcedureParameter.Type.Out)) continue;
            if (pp.getType().equals((Object)ProcedureParameter.Type.In) || pp.getType().equals((Object)ProcedureParameter.Type.InOut)) {
                ++inouts;
                if (!DataTypeManager.isLOB((String)pp.getRuntimeType())) continue;
                ++lobs;
                continue;
            }
            if (!pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) continue;
            ++outs;
        }
        if (proc.getResultSet() != null) {
            for (Column c : proc.getResultSet().getColumns()) {
                if (!DataTypeManager.isLOB((String)c.getRuntimeType())) continue;
                return false;
            }
            ++outs;
        }
        if (outs > 1) {
            return false;
        }
        return inouts <= true || lobs < true;
    }

    private static boolean isInputParameterLob(Procedure proc) {
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue) || !DataTypeManager.isLOB((String)pp.getRuntimeType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isFuntion(Procedure proc) {
        return ODataSchemaBuilder.doesProcedureReturn(proc) && proc.getUpdateCount() < 1 && !ODataSchemaBuilder.isInputParameterLob(proc);
    }

    static void buildFunction(String schemaName, Procedure proc, ArrayList<CsdlComplexType> complexTypes, ArrayList<CsdlFunction> functions, ArrayList<CsdlFunctionImport> functionImports, CsdlSchema csdlSchema) {
        EdmPrimitiveTypeKind odataType;
        CsdlFunction edmFunction = new CsdlFunction();
        edmFunction.setName(proc.getName());
        edmFunction.setBound(false);
        ArrayList<CsdlParameter> params = new ArrayList<CsdlParameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            odataType = ODataTypeManager.odataType((String)pp.getRuntimeType());
            if (pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) {
                edmFunction.setReturnType(new CsdlReturnType().setType(odataType.getFullQualifiedName()).setCollection(DataTypeManager.isArrayType((String)pp.getRuntimeType())));
                continue;
            }
            if (!pp.getType().equals((Object)ProcedureParameter.Type.In) && !pp.getType().equals((Object)ProcedureParameter.Type.InOut)) continue;
            CsdlParameter parameter = ODataSchemaBuilder.buildParameter(pp, odataType);
            ODataSchemaBuilder.addOperationParameterAnnotations(pp, parameter, csdlSchema);
            params.add(parameter);
        }
        edmFunction.setParameters(params);
        ColumnSet returnColumns = proc.getResultSet();
        if (returnColumns != null) {
            CsdlComplexType complexType = ODataSchemaBuilder.buildComplexType(proc, (ColumnSet<Procedure>)returnColumns, csdlSchema);
            complexTypes.add(complexType);
            odataType = new FullQualifiedName(schemaName, complexType.getName());
            edmFunction.setReturnType(new CsdlReturnType().setType((FullQualifiedName)odataType).setCollection(true));
        }
        CsdlFunctionImport functionImport = new CsdlFunctionImport();
        functionImport.setName(proc.getName()).setFunction(new FullQualifiedName(schemaName, proc.getName()));
        ODataSchemaBuilder.addOperationAnnotations(proc, (CsdlOperation)edmFunction, csdlSchema);
        functions.add(edmFunction);
        functionImports.add(functionImport);
    }

    private static CsdlParameter buildParameter(ProcedureParameter pp, EdmPrimitiveTypeKind odatatype) {
        CsdlParameter param = new CsdlParameter();
        param.setName(pp.getName());
        param.setType(odatatype.getFullQualifiedName());
        if (DataTypeManager.isArrayType((String)pp.getRuntimeType())) {
            param.setCollection(true);
        }
        param.setNullable(pp.getNullType() == BaseColumn.NullType.Nullable);
        if (pp.getRuntimeType().equals("string")) {
            param.setMaxLength(Integer.valueOf(pp.getLength()));
        } else if (pp.getRuntimeType().equals("bigdecimal")) {
            if (pp.getScale() < 0) {
                param.setPrecision(Integer.valueOf((int)Math.min(Integer.MAX_VALUE, (long)pp.getPrecision() - (long)pp.getScale())));
            } else {
                param.setPrecision(Integer.valueOf(pp.getPrecision()));
            }
            param.setScale(Integer.valueOf(Math.max(0, pp.getScale())));
        } else if (pp.getDefaultValue() != null) {
            // empty if block
        }
        return param;
    }

    static void buildAction(String schemaName, Procedure proc, ArrayList<CsdlComplexType> complexTypes, ArrayList<CsdlAction> actions, ArrayList<CsdlActionImport> actionImports, CsdlSchema csdlSchema) {
        CsdlAction edmAction = new CsdlAction();
        edmAction.setName(proc.getName());
        edmAction.setBound(false);
        ArrayList<CsdlParameter> params = new ArrayList<CsdlParameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            EdmPrimitiveTypeKind odatatype = ODataTypeManager.odataType((String)pp.getRuntimeType());
            if (pp.getType().equals((Object)ProcedureParameter.Type.ReturnValue)) {
                edmAction.setReturnType(new CsdlReturnType().setType(odatatype.getFullQualifiedName()).setCollection(DataTypeManager.isArrayType((String)pp.getRuntimeType())));
                continue;
            }
            if (!pp.getType().equals((Object)ProcedureParameter.Type.In) && !pp.getType().equals((Object)ProcedureParameter.Type.InOut)) continue;
            CsdlParameter parameter = ODataSchemaBuilder.buildParameter(pp, odatatype);
            ODataSchemaBuilder.addOperationParameterAnnotations(pp, parameter, csdlSchema);
            params.add(parameter);
        }
        edmAction.setParameters(params);
        ColumnSet returnColumns = proc.getResultSet();
        if (returnColumns != null) {
            CsdlComplexType complexType = ODataSchemaBuilder.buildComplexType(proc, (ColumnSet<Procedure>)returnColumns, csdlSchema);
            complexTypes.add(complexType);
            edmAction.setReturnType(new CsdlReturnType().setType(new FullQualifiedName(schemaName, complexType.getName())).setCollection(true));
        }
        CsdlActionImport actionImport = new CsdlActionImport();
        actionImport.setName(proc.getName()).setAction(new FullQualifiedName(schemaName, proc.getName()));
        ODataSchemaBuilder.addOperationAnnotations(proc, (CsdlOperation)edmAction, csdlSchema);
        actions.add(edmAction);
        actionImports.add(actionImport);
    }

    private static CsdlComplexType buildComplexType(Procedure proc, ColumnSet<Procedure> returnColumns, CsdlSchema csdlSchema) {
        CsdlComplexType complexType = new CsdlComplexType();
        String entityTypeName = proc.getName() + "_" + returnColumns.getName();
        complexType.setName(entityTypeName);
        ArrayList<CsdlProperty> props = new ArrayList<CsdlProperty>();
        Iterator iterator = returnColumns.getColumns().iterator();
        while (iterator.hasNext()) {
            Column c;
            CsdlProperty property = ODataSchemaBuilder.buildProperty(c, (c = (Column)iterator.next()).getNullType() == BaseColumn.NullType.Nullable);
            props.add(property);
            ODataSchemaBuilder.addColumnAnnotations(c, property, csdlSchema);
        }
        complexType.setProperties(props);
        return complexType;
    }

    static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }

    static boolean sameColumnSet(KeyRecord recordOne, KeyRecord recordTwo) {
        if (recordOne == null || recordTwo == null) {
            return false;
        }
        List setOne = recordOne.getColumns();
        List setTwo = recordTwo.getColumns();
        if (setOne.size() != setTwo.size()) {
            return false;
        }
        for (int i = 0; i < setOne.size(); ++i) {
            Column one = (Column)setOne.get(i);
            Column two = (Column)setTwo.get(i);
            if (one.getName().equals(two.getName())) continue;
            return false;
        }
        return true;
    }

    private static void addTableAnnotations(Table table, CsdlEntityType entityType, CsdlSchema csdlSchema) {
        if (table.getAnnotation() != null) {
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)entityType, "core.Description", table.getAnnotation());
        }
        if (table.getCardinality() != -1) {
            ODataSchemaBuilder.addIntAnnotation((CsdlAnnotatable)entityType, "teiid.CARDINALITY", table.getCardinality());
        }
        if (table.isMaterialized()) {
            if (table.getMaterializedTable() != null) {
                ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)entityType, "teiid.MATERIALIZED_TABLE", table.getMaterializedTable().getFullName());
            }
            if (table.getMaterializedStageTable() != null) {
                ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)entityType, "teiid.MATERIALIZED_STAGE_TABLE", table.getMaterializedStageTable().getFullName());
            }
        }
        if (table.getNameInSource() != null) {
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)entityType, "teiid.NAMEINSOURCE", table.getNameInSource());
        }
        if (table.getAccessPatterns() != null && !table.getAccessPatterns().isEmpty()) {
            ArrayList<String> values = new ArrayList<String>();
            for (KeyRecord record : table.getAccessPatterns()) {
                StringBuilder sb = new StringBuilder();
                for (Column c : record.getColumns()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(c.getName());
                }
                values.add(sb.toString());
            }
            ODataSchemaBuilder.addStringCollectionAnnotation((CsdlAnnotatable)entityType, "teiid.ACCESS_PATTERNS", values);
        }
        if (table.supportsUpdate()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)entityType, "teiid.UPDATABLE", table.supportsUpdate());
        }
        for (String property : table.getProperties().keySet()) {
            ODataSchemaBuilder.addTerm(ODataSchemaBuilder.normalizeTermName(property), new String[]{"EntityType"}, csdlSchema);
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)entityType, csdlSchema.getAlias() + "." + ODataSchemaBuilder.normalizeTermName(property), (String)table.getProperties().get(property));
        }
    }

    private static void addColumnAnnotations(Column column, CsdlProperty property, CsdlSchema csdlSchema) {
        if (column.getAnnotation() != null) {
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)property, "core.Description", column.getAnnotation());
        }
        if (column.getNameInSource() != null) {
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)property, "teiid.NAMEINSOURCE", column.getNameInSource());
        }
        if (!column.isSelectable()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.SELECTABLE", column.isSelectable());
        }
        if (column.isUpdatable()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.UPDATABLE", column.isUpdatable());
        }
        if (column.isCurrency()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.CURRENCY", column.isCurrency());
        }
        if (column.isCaseSensitive()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.CASE_SENSITIVE", column.isCaseSensitive());
        }
        if (column.isFixedLength()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.FIXED_LENGTH", column.isFixedLength());
        }
        if (!column.isSigned()) {
            ODataSchemaBuilder.addBooleanAnnotation((CsdlAnnotatable)property, "teiid.SIGNED", column.isSigned());
        }
        if (column.getDistinctValues() != -1) {
            ODataSchemaBuilder.addIntAnnotation((CsdlAnnotatable)property, "teiid.DISTINCT_VALUES", column.getDistinctValues());
        }
        if (column.getNullValues() != -1) {
            ODataSchemaBuilder.addIntAnnotation((CsdlAnnotatable)property, "teiid.NULL_VALUE_COUNT", column.getNullValues());
        }
        for (String str : column.getProperties().keySet()) {
            ODataSchemaBuilder.addTerm(ODataSchemaBuilder.normalizeTermName(str), new String[]{"Property"}, csdlSchema);
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)property, csdlSchema.getAlias() + "." + ODataSchemaBuilder.normalizeTermName(str), (String)column.getProperties().get(str));
        }
    }

    private static void addOperationAnnotations(Procedure proc, CsdlOperation operation, CsdlSchema csdlSchema) {
        if (proc.getAnnotation() != null) {
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)operation, "core.Description", proc.getAnnotation());
        }
        if (proc.getNameInSource() != null) {
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)operation, "teiid.NAMEINSOURCE", proc.getNameInSource());
        }
        if (proc.getUpdateCount() != -1) {
            ODataSchemaBuilder.addIntAnnotation((CsdlAnnotatable)operation, "teiid.UPDATECOUNT", proc.getUpdateCount());
        }
        for (String str : proc.getProperties().keySet()) {
            ODataSchemaBuilder.addTerm(ODataSchemaBuilder.normalizeTermName(str), new String[]{"Action", "Function"}, csdlSchema);
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)operation, csdlSchema.getAlias() + "." + ODataSchemaBuilder.normalizeTermName(str), (String)proc.getProperties().get(str));
        }
    }

    private static void addOperationParameterAnnotations(ProcedureParameter procedure, CsdlParameter parameter, CsdlSchema csdlSchema) {
        if (procedure.getAnnotation() != null) {
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)parameter, "core.Description", procedure.getAnnotation());
        }
        if (procedure.getNameInSource() != null) {
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)parameter, "teiid.NAMEINSOURCE", procedure.getNameInSource());
        }
        for (String str : procedure.getProperties().keySet()) {
            ODataSchemaBuilder.addTerm(ODataSchemaBuilder.normalizeTermName(str), new String[]{"Parameter"}, csdlSchema);
            ODataSchemaBuilder.addStringAnnotation((CsdlAnnotatable)parameter, csdlSchema.getAlias() + "." + ODataSchemaBuilder.normalizeTermName(str), (String)procedure.getProperties().get(str));
        }
    }

    private static void addStringAnnotation(CsdlAnnotatable recipent, String term, String value) {
        CsdlAnnotation annotation = new CsdlAnnotation();
        annotation.setTerm(term);
        annotation.setExpression((CsdlExpression)new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.String, value));
        recipent.getAnnotations().add(annotation);
    }

    private static void addIntAnnotation(CsdlAnnotatable recipent, String term, int value) {
        CsdlAnnotation annotation = new CsdlAnnotation();
        annotation.setTerm(term);
        annotation.setExpression((CsdlExpression)new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.Int, String.valueOf(value)));
        recipent.getAnnotations().add(annotation);
    }

    private static void addBooleanAnnotation(CsdlAnnotatable recipent, String term, boolean value) {
        CsdlAnnotation annotation = new CsdlAnnotation();
        annotation.setTerm(term);
        annotation.setExpression((CsdlExpression)new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.Bool, String.valueOf(value)));
        recipent.getAnnotations().add(annotation);
    }

    private static void addStringCollectionAnnotation(CsdlAnnotatable recipent, String term, List<String> values) {
        CsdlAnnotation annotation = new CsdlAnnotation();
        annotation.setTerm(term);
        CsdlCollection collection = new CsdlCollection();
        for (String value : values) {
            collection.getItems().add(new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.String, value));
        }
        annotation.setExpression((CsdlExpression)collection);
        recipent.getAnnotations().add(annotation);
    }

    private static void addTerm(String property, String[] appliesTo, CsdlSchema schema) {
        CsdlTerm term = schema.getTerm(property);
        if (term == null) {
            term = new CsdlTerm();
            term.setName(property);
            term.setType("Edm.String");
            schema.getTerms().add(term);
        }
        if (term.getAppliesTo().isEmpty() || !term.getAppliesTo().contains(appliesTo)) {
            for (int i = 0; i < appliesTo.length; ++i) {
                term.getAppliesTo().add(appliesTo[i]);
            }
        }
    }

    private static String normalizeTermName(String name) {
        int end;
        if (name.startsWith("{") && (end = name.indexOf("}")) != -1) {
            String modified = null;
            String namespace = name.substring(1, end);
            for (Map.Entry entry : MetadataFactory.BUILTIN_NAMESPACES.entrySet()) {
                if (!((String)entry.getValue()).equals(namespace)) continue;
                modified = (String)entry.getKey();
                break;
            }
            return modified + ":" + name.substring(end + 1);
        }
        return name;
    }
}

