/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import javax.xml.stream.XMLStreamException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlConstantExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.apache.olingo.commons.api.edmx.EdmxReference;
import org.apache.olingo.commons.api.edmx.EdmxReferenceInclude;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.server.core.MetadataParser;
import org.apache.olingo.server.core.SchemaBasedEdmProvider;
import org.teiid.core.TeiidRuntimeException;

public class TeiidEdmProvider
extends SchemaBasedEdmProvider {
    public TeiidEdmProvider(String baseUri, CsdlSchema schema, String invalidXmlReplacementChar) throws XMLStreamException, ODataException {
        EdmxReference olingoRef = new EdmxReference(URI.create(baseUri + "/static/org.apache.olingo.v1.xml"));
        EdmxReferenceInclude include = new EdmxReferenceInclude("org.apache.olingo.v1", "olingo-extensions");
        olingoRef.addInclude(include);
        this.addReference(olingoRef);
        EdmxReference teiidRef = new EdmxReference(URI.create(baseUri + "/static/org.teiid.v1.xml"));
        EdmxReferenceInclude teiidInclude = new EdmxReferenceInclude("org.teiid.v1", "teiid");
        teiidRef.addInclude(teiidInclude);
        this.addReference(teiidRef);
        MetadataParser parser = new MetadataParser();
        parser.parseAnnotations(true);
        parser.useLocalCoreVocabularies(true);
        parser.implicitlyLoadCoreVocabularies(true);
        SchemaBasedEdmProvider provider = parser.buildEdmProvider((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org.apache.olingo.v1.xml")));
        this.addVocabularySchema("org.apache.olingo.v1", provider);
        provider = parser.buildEdmProvider((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org.teiid.v1.xml")));
        this.addVocabularySchema("org.teiid.v1", provider);
        provider = parser.buildEdmProvider((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("Org.OData.Core.V1.xml")));
        this.addVocabularySchema("Org.OData.Core.V1", provider);
        if (invalidXmlReplacementChar != null) {
            CsdlAnnotation xmlCharReplacement = new CsdlAnnotation();
            xmlCharReplacement.setTerm("org.apache.olingo.v1.xml10-incompatible-char-replacement");
            xmlCharReplacement.setExpression((CsdlExpression)new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.String, invalidXmlReplacementChar));
            schema.getAnnotations().add(xmlCharReplacement);
        }
        this.addSchema(schema);
    }

    public CsdlTerm getTerm(FullQualifiedName fqn) throws ODataException {
        CsdlTerm term = super.getTerm(fqn);
        if (term == null) {
            throw new TeiidRuntimeException(fqn.toString() + " unknown term");
        }
        return term;
    }
}

