/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.ServletException;
import javax.xml.stream.XMLStreamException;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.core.OData4Impl;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidProcessingException;
import org.teiid.metadata.Schema;
import org.teiid.odata.api.Client;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.service.ODataSchemaBuilder;
import org.teiid.olingo.service.TeiidEdmProvider;
import org.teiid.olingo.service.TeiidServiceHandler;

public class OlingoBridge {
    public static List<String> RESERVED = Arrays.asList("teiid", "edm", "core", "olingo-extensions");
    private ConcurrentSkipListMap<String, HandlerInfo> handlers = new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerInfo getHandlers(String baseUri, Client client, String schemaName) throws ServletException, TeiidProcessingException {
        HandlerInfo handler = this.handlers.get(schemaName);
        if (handler != null) {
            return handler;
        }
        VDBMetaData vdb = client.getVDB();
        Schema teiidSchema = client.getMetadataStore().getSchema(schemaName);
        if (teiidSchema == null || !OlingoBridge.isVisible(vdb, teiidSchema)) {
            throw new TeiidProcessingException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16022, new Object[0]));
        }
        OlingoBridge olingoBridge = this;
        synchronized (olingoBridge) {
            handler = this.handlers.get(schemaName);
            if (handler != null) {
                return handler;
            }
            this.loadAllHandlers(baseUri, client, vdb);
        }
        return this.handlers.get(schemaName);
    }

    private void loadAllHandlers(String baseUri, Client client, final VDBMetaData vdb) throws ServletException {
        final LinkedHashMap<String, ODataSchemaBuilder.ODataSchemaInfo> infoMap = new LinkedHashMap<String, ODataSchemaBuilder.ODataSchemaInfo>();
        TreeSet<String> aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        aliases.addAll(RESERVED);
        for (Schema s : client.getMetadataStore().getSchemaList()) {
            if (!OlingoBridge.isVisible(vdb, s)) continue;
            int i = 1;
            String alias = s.getName();
            while (!aliases.add(alias)) {
                alias = alias + "_" + i++;
            }
            ODataSchemaBuilder.ODataSchemaInfo info = ODataSchemaBuilder.buildStructuralMetadata(vdb.getFullName(), s, alias);
            infoMap.put(s.getName(), info);
            try {
                info.edmProvider = new TeiidEdmProvider(baseUri, info.schema, client.getProperty("invalid-xml10-character-replacement"));
            }
            catch (XMLStreamException e) {
                throw new ServletException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16054, new Object[0]));
            }
        }
        for (Schema s : client.getMetadataStore().getSchemaList()) {
            if (!OlingoBridge.isVisible(vdb, s)) continue;
            final ODataSchemaBuilder.ODataSchemaInfo info = (ODataSchemaBuilder.ODataSchemaInfo)infoMap.get(s.getName());
            ODataSchemaBuilder.buildNavigationProperties(s, info.entityTypes, info.entitySets, new ODataSchemaBuilder.SchemaResolver(){

                @Override
                public ODataSchemaBuilder.ODataSchemaInfo getSchemaInfo(String name) {
                    ODataSchemaBuilder.ODataSchemaInfo result = (ODataSchemaBuilder.ODataSchemaInfo)infoMap.get(name);
                    if (result != null && info != result) {
                        info.edmProvider.addReferenceSchema(vdb.getFullName(), result.schema.getNamespace(), result.schema.getAlias(), result.edmProvider);
                        result.edmProvider.addReferenceSchema(vdb.getFullName(), info.schema.getNamespace(), info.schema.getAlias(), info.edmProvider);
                    }
                    return result;
                }
            });
        }
        OData odata = OData4Impl.newInstance();
        for (Map.Entry entry : infoMap.entrySet()) {
            TeiidEdmProvider edmProvider = ((ODataSchemaBuilder.ODataSchemaInfo)entry.getValue()).edmProvider;
            ServiceMetadata metadata = odata.createServiceMetadata((CsdlEdmProvider)edmProvider, edmProvider.getReferences());
            ODataHttpHandler handler = odata.createHandler(metadata);
            handler.register((Processor)new TeiidServiceHandler((String)entry.getKey()));
            this.handlers.put((String)entry.getKey(), new HandlerInfo(handler, metadata));
        }
    }

    private static boolean isVisible(VDBMetaData vdb, Schema schema) {
        String schemaName = schema.getName();
        ModelMetaData model = vdb.getModel(schemaName);
        if (model == null) {
            return false;
        }
        return model.isVisible();
    }

    public static class HandlerInfo {
        public final ODataHttpHandler oDataHttpHandler;
        public final ServiceMetadata serviceMetadata;

        HandlerInfo(ODataHttpHandler handler, ServiceMetadata serviceMetadata) {
            this.oDataHttpHandler = handler;
            this.serviceMetadata = serviceMetadata;
        }
    }
}

