/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo;

import java.net.URI;
import java.util.Map;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;
import org.teiid.odata.api.ComplexResponse;
import org.teiid.olingo.TeiidODataJsonSerializer;

public class EdmComplexResponse
extends ServiceResponse {
    private final TeiidODataJsonSerializer serializer;
    private final ContentType responseContentType;
    private final ContextURL contextURL;

    private EdmComplexResponse(ServiceMetadata metadata, ODataResponse response, TeiidODataJsonSerializer serializer, ContentType responseContentType, Map<String, String> preferences, ContextURL contextURL) {
        super(metadata, response, preferences);
        this.serializer = serializer;
        this.responseContentType = responseContentType;
        this.contextURL = contextURL;
    }

    public static EdmComplexResponse getInstance(ServiceRequest request, ContextURL contextURL, boolean referencesOnly, ODataResponse response) throws ContentNegotiatorException, SerializerException {
        ContentType contentType = request.getResponseContentType();
        if (!contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            throw new SerializerException("Unsupported format for complex response: " + contentType.toContentTypeString(), (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_FORMAT, new String[]{contentType.toContentTypeString()});
        }
        return new EdmComplexResponse(request.getServiceMetaData(), response, new TeiidODataJsonSerializer(contentType), request.getResponseContentType(), request.getPreferences(), contextURL);
    }

    public void writeComplexType(ComplexResponse complexResult, URI next) throws SerializerException {
        assert (!this.isClosed());
        if (complexResult == null) {
            this.writeNotFound(true);
            return;
        }
        complexResult.serialize(this.response, this.serializer, this.metadata, this.contextURL, next);
        this.writeOK(this.responseContentType);
        this.close();
    }

    public void accepts(ServiceResponseVisior visitor) throws ODataLibraryException, ODataApplicationException {
    }

    public void writeError(ODataServerError error) {
        try {
            this.writeContent(this.serializer.error(error).getContent(), error.getStatusCode(), true);
        }
        catch (SerializerException e) {
            this.writeServerError(true);
        }
    }
}

