/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmPropertyImpl;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.olingo.service.DocumentNode;
import org.teiid.olingo.service.ProcedureSQLBuilder;
import org.teiid.olingo.service.TeiidServiceHandler;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;

public class ComplexDocumentNode
extends DocumentNode {
    private ProcedureSQLBuilder.ProcedureReturn procedureReturn;
    private Procedure procedure;

    public static ComplexDocumentNode buildComplexDocumentNode(EdmOperation edmOperation, MetadataStore metadata, TeiidServiceHandler.UniqueNameGenerator nameGenerator) {
        ComplexDocumentNode resource = new ComplexDocumentNode();
        FullQualifiedName fqn = edmOperation.getFullQualifiedName();
        String withoutVDB = fqn.getNamespace().substring(fqn.getNamespace().lastIndexOf(46) + 1);
        Schema schema = metadata.getSchema(withoutVDB);
        Procedure procedure = schema.getProcedure(edmOperation.getName());
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName(procedure.getFullName());
        for (int i = 0; i < procedure.getParameters().size(); ++i) {
            storedQuery.setParameter(new SPParameter(i + 1, (Expression)new Reference(i)));
        }
        String group = nameGenerator.getNextGroup();
        SubqueryFromClause sfc = new SubqueryFromClause(group, (Command)storedQuery);
        resource.setGroupSymbol(new GroupSymbol(group));
        resource.setFromClause((FromClause)sfc);
        resource.procedure = procedure;
        return resource;
    }

    @Override
    public List<String> getKeyColumnNames() {
        return new ArrayList<String>();
    }

    public void setProcedureReturn(ProcedureSQLBuilder.ProcedureReturn pp) {
        this.procedureReturn = pp;
    }

    public ProcedureSQLBuilder.ProcedureReturn getProcedureReturn() {
        return this.procedureReturn;
    }

    @Override
    protected void addAllColumns(boolean onlyPK) {
        for (Column column : this.procedure.getResultSet().getColumns()) {
            if (!column.isSelectable()) continue;
            EdmReturnType returnType = this.procedureReturn.getReturnType();
            EdmComplexType complexType = (EdmComplexType)returnType.getType();
            EdmPropertyImpl edmProperty = (EdmPropertyImpl)complexType.getProperty(column.getName());
            this.addProjectedColumn((Expression)new ElementSymbol(column.getName(), this.getGroupSymbol()), edmProperty.getType(), (EdmProperty)edmProperty, edmProperty.isCollection());
        }
    }

    @Override
    protected void addProjectedColumn(String columnName, Expression expr) {
        EdmReturnType returnType = this.procedureReturn.getReturnType();
        EdmComplexType complexType = (EdmComplexType)returnType.getType();
        EdmPropertyImpl edmProperty = (EdmPropertyImpl)complexType.getProperty(columnName);
        this.addProjectedColumn(expr, edmProperty.getType(), (EdmProperty)edmProperty, edmProperty.isCollection());
    }

    @Override
    public String getName() {
        return this.procedure.getName();
    }

    @Override
    public Column getColumnByName(String name) {
        for (Column column : this.procedure.getResultSet().getColumns()) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    @Override
    public String getFullName() {
        return this.procedure.getFullName();
    }
}

