/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.core.serializer.xml.ODataXmlSerializer;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.vdb.runtime.VDBKey;

public class OpenApiHandler {
    private static final String SWAGGER_JSON = "/swagger.json";
    private static final String OPENAPI_JSON = "/openapi.json";
    public static final String SCHEME = "scheme";
    public static final String HOST = "host";
    public static final String BASEPATH = "basePath";
    public static final String TITLE = "info-title";
    public static final String DESCRIPTION = "info-description";
    public static final String VERSION = "info-version";
    public static final String OPENAPI_VERSION = "openapi-version";
    private ServletContext servletContext;
    private Map<List<?>, File> cachedMetadata = new ConcurrentHashMap();
    private Templates templates;
    private OpenApiVersion defaultVersion = OpenApiVersion.V2;

    public OpenApiHandler(ServletContext servletContext) throws ServletException {
        this.servletContext = servletContext;
        try (InputStream template = this.getClass().getResourceAsStream("/V4-CSDL-to-OpenAPI.xsl");){
            this.templates = TransformerFactory.newInstance().newTemplates(new StreamSource(template));
        }
        catch (IOException | TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            throw new ServletException(e);
        }
        String defaultValue = servletContext.getInitParameter("default-openapi-version");
        if (defaultValue != null) {
            this.defaultVersion = OpenApiVersion.valueOf("V" + defaultValue);
        }
    }

    public OpenApiVersion getOpenApiMetadataRequestVersion(HttpServletRequest request, String uri) {
        if (request.getMethod().equalsIgnoreCase("GET")) {
            if (uri.endsWith(SWAGGER_JSON)) {
                return OpenApiVersion.V2;
            }
            if (uri.endsWith(OPENAPI_JSON)) {
                String version = request.getParameter("version");
                if (version == null) {
                    return this.defaultVersion;
                }
                return OpenApiVersion.valueOf("V" + version);
            }
        }
        return null;
    }

    public boolean processOpenApiMetadata(HttpServletRequest httpRequest, VDBKey key, String uri, String modelName, ServletResponse response, ServiceMetadata serviceMetadata, Map<String, String> parameters) throws TeiidProcessingException {
        OpenApiVersion version = this.getOpenApiMetadataRequestVersion(httpRequest, uri);
        if (version == null) {
            return false;
        }
        try {
            List<Serializable> cacheKey = Arrays.asList(new Serializable[]{key, modelName, version});
            File f = this.cachedMetadata.get(cacheKey);
            if (f == null || !f.exists()) {
                Transformer transformer = this.templates.newTransformer();
                transformer.setParameter(SCHEME, httpRequest.getScheme());
                transformer.setParameter(HOST, httpRequest.getServerName() + ":" + httpRequest.getServerPort());
                transformer.setParameter(BASEPATH, uri.substring(0, uri.length() - 13));
                transformer.setParameter(TITLE, key.getName() + " - " + modelName);
                transformer.setParameter(OPENAPI_VERSION, version.key);
                transformer.setParameter(DESCRIPTION, modelName);
                transformer.setParameter(VERSION, key.getVersion());
                if (parameters != null) {
                    parameters.forEach((k, v) -> transformer.setParameter((String)k, v));
                }
                File appTempDir = (File)this.servletContext.getAttribute("javax.servlet.context.tempdir");
                f = File.createTempFile(key + modelName, ".json", appTempDir);
                f.deleteOnExit();
                ODataXmlSerializer oxs = new ODataXmlSerializer();
                try (FileOutputStream outputStream = new FileOutputStream(f);
                     InputStream is = oxs.metadataDocument(serviceMetadata).getContent();){
                    transformer.transform(new StreamSource(is), new StreamResult(outputStream));
                }
                this.cachedMetadata.put(cacheKey, f);
            }
            response.setContentType("application/json");
            ObjectConverterUtil.write((OutputStream)response.getOutputStream(), (InputStream)new FileInputStream(f), (int)-1);
            response.flushBuffer();
        }
        catch (IOException | TransformerException | TransformerFactoryConfigurationError | ODataLibraryException e) {
            throw new TeiidProcessingException(e);
        }
        return true;
    }

    public static enum OpenApiVersion {
        V2("2.0"),
        V3("3.0");

        String key;

        private OpenApiVersion(String key) {
            this.key = key;
        }
    }
}

