/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.web.gzip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.olingo.web.gzip.GzipMessageResponse;

public class TestGzipMessageResponse {
    static final String TEST_STRING = "test string";
    static final ByteBuffer TEST_STRING_IN_GZIP;
    private GzipMessageResponse response;
    private ServletOutputStream stream;
    private ByteBuffer streamBytes;

    @Before
    public void prepareResponse() throws IOException {
        this.streamBytes = ByteBuffer.allocate(100);
        this.stream = new ServletOutputStream(){

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int b) throws IOException {
                TestGzipMessageResponse.this.streamBytes.put((byte)b);
            }
        };
        this.response = new GzipMessageResponse(TestGzipMessageResponse.mockResponse(this.stream));
    }

    @Test
    public void testIllegalGetOutputStreamInvocation() throws IOException {
        this.response.getWriter();
        try {
            this.response.getOutputStream();
            Assert.fail((String)("Expected " + IllegalArgumentException.class));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testIllegalGetWriterInvocation() throws IOException {
        this.response.getOutputStream();
        try {
            this.response.getWriter();
            Assert.fail((String)("Expected " + IllegalArgumentException.class));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteToWriter() throws IOException {
        PrintWriter w = this.response.getWriter();
        w.write(TEST_STRING);
        w.close();
        this.streamBytes.flip();
        Assert.assertEquals((String)"Expected output in GZIP.", (Object)TEST_STRING_IN_GZIP, (Object)this.streamBytes);
    }

    @Test
    public void testWriteToOutputStream() throws Exception {
        ServletOutputStream sos = this.response.getOutputStream();
        sos.write(TEST_STRING.getBytes());
        sos.close();
        this.streamBytes.flip();
        Assert.assertEquals((String)"Expected output in GZIP.", (Object)TEST_STRING_IN_GZIP, (Object)this.streamBytes);
    }

    private static HttpServletResponse mockResponse(ServletOutputStream stream) throws IOException {
        HttpServletResponse out = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ((HttpServletResponse)Mockito.doReturn((Object)stream).when((Object)out)).getOutputStream();
        ((HttpServletResponse)Mockito.doThrow(Error.class).when((Object)out)).getWriter();
        return out;
    }

    static {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bos);
            gos.write(TEST_STRING.getBytes());
            gos.finish();
            gos.flush();
            gos.close();
            TEST_STRING_IN_GZIP = ByteBuffer.wrap(bos.toByteArray());
        }
        catch (IOException ex) {
            throw new InternalError("No exception expected: " + ex.toString());
        }
    }
}

